/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.transport.mailets.jsieve.ActionContext;
import org.apache.james.transport.mailets.jsieve.FileIntoAction;
import org.apache.james.transport.mailets.jsieve.MailAction;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.ActionDiscard;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public class DiscardAction
extends FileIntoAction
implements MailAction {
    @Override
    public void execute(Action action, Mail mail, ActionContext context) throws MessagingException {
        if (action instanceof ActionDiscard) {
            DiscardAction.removeRecipient(mail, context);
        }
    }

    public static void removeRecipient(Mail mail, ActionContext context) {
        mail.setRecipients((Collection)FluentIterable.from((Iterable)mail.getRecipients()).filter(DiscardAction.isNot(context.getRecipient())).toList());
    }

    private static Predicate<MailAddress> isNot(final MailAddress recipient) {
        return new Predicate<MailAddress>(){

            public boolean apply(MailAddress input) {
                return !input.equals((Object)recipient);
            }
        };
    }
}

