/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.slf4j.Logger;

public class CommonsLoggingAdapter
implements Log {
    public static final int TRACE = 6;
    public static final int DEBUG = 5;
    public static final int INFO = 4;
    public static final int WARN = 3;
    public static final int ERROR = 2;
    public static final int FATAL = 1;
    private final Logger logger;
    private final int level;

    public static Builder builder() {
        return new Builder();
    }

    private CommonsLoggingAdapter(Logger logger, int level) {
        this.logger = logger;
        this.level = level;
    }

    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.logger.debug(message == null ? "NULL" : message.toString());
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.logger.debug(message == null ? "NULL" : message.toString(), t);
        }
    }

    public void error(Object message) {
        if (this.isErrorEnabled()) {
            this.logger.error(message == null ? "NULL" : message.toString());
        }
    }

    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.logger.error(message == null ? "NULL" : message.toString(), t);
        }
    }

    public void fatal(Object message) {
        if (this.isFatalEnabled()) {
            this.logger.error(message == null ? "NULL" : message.toString());
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.logger.error(message == null ? "NULL" : message.toString(), t);
        }
    }

    public void info(Object message) {
        if (this.isInfoEnabled()) {
            this.logger.info(message == null ? "NULL" : message.toString());
        }
    }

    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.logger.info(message == null ? "NULL" : message.toString(), t);
        }
    }

    public boolean isDebugEnabled() {
        return this.level >= 5;
    }

    public boolean isErrorEnabled() {
        return this.level >= 2;
    }

    public boolean isFatalEnabled() {
        return this.level >= 1;
    }

    public boolean isInfoEnabled() {
        return this.level >= 4;
    }

    public boolean isTraceEnabled() {
        return this.level >= 6;
    }

    public boolean isWarnEnabled() {
        return this.level >= 3;
    }

    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            this.logger.debug(message == null ? "NULL" : message.toString());
        }
    }

    public void trace(Object message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.logger.debug(message == null ? "NULL" : message.toString(), t);
        }
    }

    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            this.logger.warn(message == null ? "NULL" : message.toString());
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.logger.warn(message == null ? "NULL" : message.toString(), t);
        }
    }

    public static class Builder {
        private Optional<Boolean> verbose = Optional.absent();
        private Optional<Boolean> quiet = Optional.absent();
        private Logger logger;

        public Builder wrappedLogger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder verbose(boolean verbose) {
            this.verbose = Optional.of((Object)verbose);
            return this;
        }

        public Builder quiet(boolean quiet) {
            this.quiet = Optional.of((Object)quiet);
            return this;
        }

        public CommonsLoggingAdapter build() {
            Preconditions.checkNotNull((Object)this.logger);
            Boolean quietParameter = (Boolean)this.quiet.or((Object)false);
            Boolean verboseParameter = (Boolean)this.verbose.or((Object)false);
            Preconditions.checkState((verboseParameter == false || quietParameter == false ? 1 : 0) != 0, (Object)"You can not specify a logger both verbose and quiet");
            return new CommonsLoggingAdapter(this.logger, this.computeLogLevel(quietParameter, verboseParameter));
        }

        private int computeLogLevel(boolean quiet, boolean verbose) {
            if (verbose) {
                return 6;
            }
            if (quiet) {
                return 1;
            }
            return 3;
        }
    }
}

