/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.FlowedMessageUtils;
import org.apache.mailet.base.GenericMailet;

@Experimental
public class UnwrapText
extends GenericMailet {
    public static final String PARAMETER_NAME_QUOTEWIDTH = "quotewidth";
    private int quotewidth;

    public String getMailetInfo() {
        return "UnwrapText";
    }

    public void init() throws MailetException {
        this.quotewidth = Integer.parseInt(this.getInitParameter(PARAMETER_NAME_QUOTEWIDTH, "-10"));
    }

    public void service(Mail mail) throws MailetException {
        try {
            if (FlowedMessageUtils.isFlowedTextMessage((Message)mail.getMessage())) {
                FlowedMessageUtils.deflowMessage((Message)mail.getMessage());
            } else {
                Object o = mail.getMessage().getContent();
                if (o instanceof String) {
                    String unwrapped = UnwrapText.unwrap((String)o, this.quotewidth);
                    mail.getMessage().setContent((Object)unwrapped, mail.getMessage().getContentType());
                    mail.getMessage().saveChanges();
                }
            }
        }
        catch (MessagingException e) {
            throw new MailetException("Could not unwrap message", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MailetException("Could not unwrap message", (Exception)e);
        }
    }

    public static String unwrap(String text) {
        return UnwrapText.unwrap(text, -10);
    }

    public static String unwrap(String text, int qwidth) {
        String[] lines = text.split("\r\n|\n", -1);
        Pattern p1 = Pattern.compile("([> ]*)(.*[^ .?!][ ]*)$", 0);
        Pattern p2 = Pattern.compile("^([> ]*)(([a-z\u00e0\u00e8\u00e9\u00ec\u00f2\u00f9][^ \t\r\n]*|[0-9][0-9,.]*)([ \t].*$|$))", 0);
        int width = 0;
        for (int i = 0; i < lines.length - 1; ++i) {
            String l = lines[i].trim();
            if (l.length() <= width) continue;
            width = l.length();
        }
        if (width < 40) {
            return text;
        }
        if (qwidth < 0) {
            qwidth = width - qwidth;
        }
        StringBuilder result = new StringBuilder();
        int prevWrapped = 0;
        for (int i = 0; i < lines.length; ++i) {
            int w;
            boolean b;
            Matcher m2;
            if (prevWrapped != 0) {
                if (prevWrapped > 0) {
                    if (result.charAt(result.length() - 1) != ' ') {
                        result.append(" ");
                    }
                } else {
                    result.append("\r\n");
                }
            }
            String l = lines[i];
            Matcher m1 = p1.matcher(l);
            Matcher matcher = m2 = i < lines.length - 1 ? p2.matcher(lines[i + 1]) : null;
            if (m1.matches() && i < lines.length - 1 && m2.matches() && ((b = m1.group(1).trim().equals(m2.group(1).trim())) && l.length() + m2.group(3).length() + 1 > width || !b && m2.group(1).trim().equals("") && (w = l.length() + m2.group(2).trim().length() + 1) > width && w <= qwidth)) {
                if (b) {
                    if (prevWrapped > 0 && m1.groupCount() >= 2) {
                        result.append(m1.group(2));
                    } else {
                        result.append(l);
                    }
                    prevWrapped = 1;
                    continue;
                }
                lines[i + 1] = l + (l.charAt(l.length() - 1) != ' ' ? " " : "") + m2.group(2).trim();
                if (prevWrapped == 0) continue;
                if (prevWrapped > 0) {
                    result.deleteCharAt(result.length() - 1);
                    continue;
                }
                result.delete(result.length() - 2, result.length());
                continue;
            }
            Matcher m3 = p2.matcher(l);
            if (prevWrapped > 0 && m3.matches()) {
                result.append(m3.group(2));
            } else {
                result.append(lines[i]);
            }
            prevWrapped = -1;
        }
        return result.toString();
    }
}

