/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.MessagingException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.transport.mailets.delivery.MailboxAppender;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;

@Experimental
public class ToSenderFolder
extends GenericMailet {
    private final UsersRepository usersRepository;
    private final MailboxManager mailboxManager;
    private String folder;
    private boolean consume;
    private MailboxAppender mailboxAppender;

    @Inject
    public ToSenderFolder(UsersRepository usersRepository, @Named(value="mailboxmanager") MailboxManager mailboxManager) {
        this.usersRepository = usersRepository;
        this.mailboxManager = mailboxManager;
    }

    public void service(Mail mail) throws MessagingException {
        if (!mail.getState().equals("ghost")) {
            this.doService(mail);
            if (this.consume) {
                mail.setState("ghost");
            }
        }
    }

    private void doService(Mail mail) throws MessagingException {
        MailAddress sender = mail.getSender();
        String username = this.retrieveUser(sender);
        this.mailboxAppender.append(mail.getMessage(), username, this.folder);
        this.log("Local delivery with ToSenderFolder mailet for mail " + mail.getName() + " with sender " + sender.toString() + " in folder " + this.folder);
    }

    private String retrieveUser(MailAddress sender) throws MessagingException {
        try {
            return this.usersRepository.getUser(sender);
        }
        catch (UsersRepositoryException e) {
            throw new MessagingException(e.getMessage());
        }
    }

    public void init() throws MessagingException {
        this.folder = this.getInitParameter("folder", "Sent");
        this.consume = this.getInitParameter("consume", false);
        this.mailboxAppender = new MailboxAppender(this.mailboxManager, this.getMailetContext().getLogger());
    }

    public String getMailetInfo() {
        return ToSenderFolder.class.getName() + " Mailet";
    }
}

