/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class ToRepository
extends GenericMailet {
    private MailRepository repository;
    private boolean passThrough = false;
    private String repositoryPath;
    private MailRepositoryStore mailStore;

    @Inject
    public void setStore(MailRepositoryStore mailStore) {
        this.mailStore = mailStore;
    }

    public void init() throws MessagingException {
        this.repositoryPath = this.getInitParameter("repositoryPath");
        this.passThrough = this.getPassThroughParameter();
        this.repository = this.selectRepository();
    }

    private boolean getPassThroughParameter() {
        try {
            return this.getInitParameter("passThrough", false);
        }
        catch (Exception e) {
            return false;
        }
    }

    private MailRepository selectRepository() throws MessagingException {
        try {
            return this.mailStore.select(this.repositoryPath);
        }
        catch (Exception e) {
            throw new MessagingException("Failed to retrieve MailRepository for url " + this.repositoryPath, e);
        }
    }

    public void service(Mail mail) throws MessagingException {
        String logBuffer = "Storing mail " + mail.getName() + " in " + this.repositoryPath;
        this.log(logBuffer);
        this.repository.store(mail);
        if (!this.passThrough) {
            mail.setState("ghost");
        }
    }

    public String getMailetInfo() {
        return "ToRepository Mailet";
    }
}

