/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.MessagingException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.transport.mailets.delivery.MailDispatcher;
import org.apache.james.transport.mailets.delivery.MailboxAppender;
import org.apache.james.transport.mailets.delivery.SimpleMailStore;
import org.apache.james.user.api.UsersRepository;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class ToRecipientFolder
extends GenericMailet {
    public static final String FOLDER_PARAMETER = "folder";
    public static final String CONSUME_PARAMETER = "consume";
    private final MailboxManager mailboxManager;
    private final UsersRepository usersRepository;
    private final MetricFactory metricFactory;
    private MailDispatcher mailDispatcher;

    @Inject
    public ToRecipientFolder(@Named(value="mailboxmanager") MailboxManager mailboxManager, UsersRepository usersRepository, MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
        this.mailboxManager = mailboxManager;
        this.usersRepository = usersRepository;
    }

    public void service(Mail mail) throws MessagingException {
        this.mailDispatcher.dispatch(mail);
    }

    public void init() throws MessagingException {
        this.mailDispatcher = MailDispatcher.builder().mailStore(SimpleMailStore.builder().mailboxAppender(new MailboxAppender(this.mailboxManager, this.getMailetContext().getLogger())).usersRepository(this.usersRepository).folder(this.getInitParameter(FOLDER_PARAMETER, "INBOX")).metric(this.metricFactory.generate("localDeliveredMails")).build()).consume(this.getInitParameter(CONSUME_PARAMETER, false)).mailetContext(this.getMailetContext()).build();
    }

    public String getMailetInfo() {
        return ToRecipientFolder.class.getName() + " Mailet";
    }
}

