/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.transport.mailets.jsieve.CommonsLoggingAdapter;
import org.apache.james.transport.mailets.jsieve.ResourceLocator;
import org.apache.james.transport.mailets.jsieve.delivery.SieveExecutor;
import org.apache.james.transport.mailets.jsieve.delivery.SievePoster;
import org.apache.james.user.api.UsersRepository;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;

public class Sieve
extends GenericMailet {
    private final UsersRepository usersRepository;
    private final ResourceLocator resourceLocator;
    private SieveExecutor sieveExecutor;

    @Inject
    public Sieve(UsersRepository usersRepository, SieveRepository sieveRepository) throws MessagingException {
        this(usersRepository, new ResourceLocator(sieveRepository, usersRepository));
    }

    public Sieve(UsersRepository usersRepository, ResourceLocator resourceLocator) throws MessagingException {
        this.usersRepository = usersRepository;
        this.resourceLocator = resourceLocator;
    }

    public String getMailetInfo() {
        return "Sieve Mailet";
    }

    public void init() throws MessagingException {
        CommonsLoggingAdapter log = CommonsLoggingAdapter.builder().wrappedLogger(this.getMailetContext().getLogger()).quiet(this.getInitParameter("quiet", false)).verbose(this.getInitParameter("verbose", false)).build();
        this.sieveExecutor = SieveExecutor.builder().resourceLocator(this.resourceLocator).mailetContext(this.getMailetContext()).log(log).sievePoster(new SievePoster(this.usersRepository, "INBOX")).build();
    }

    public void service(Mail mail) throws MessagingException {
        for (MailAddress recipient : mail.getRecipients()) {
            this.sieveExecutor.execute(recipient, mail);
        }
    }
}

