/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.collect.HashMultimap;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.transport.mailets.remoteDelivery.Bouncer;
import org.apache.james.transport.mailets.remoteDelivery.DeliveryRunnable;
import org.apache.james.transport.mailets.remoteDelivery.RemoteDeliveryConfiguration;
import org.apache.james.transport.mailets.remoteDelivery.RemoteDeliverySocketFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;

public class RemoteDelivery
extends GenericMailet {
    public static final String NAME_JUNCTION = "-to-";
    private final DNSService dnsServer;
    private final DomainList domainList;
    private final MailQueueFactory queueFactory;
    private final MetricFactory metricFactory;
    private final AtomicBoolean isDestroyed;
    private final THREAD_STATE startThreads;
    private MailQueue queue;
    private Logger logger;
    private RemoteDeliveryConfiguration configuration;
    private ExecutorService executor;

    @Inject
    public RemoteDelivery(DNSService dnsServer, DomainList domainList, MailQueueFactory queueFactory, MetricFactory metricFactory) {
        this(dnsServer, domainList, queueFactory, metricFactory, THREAD_STATE.START_THREADS);
    }

    public RemoteDelivery(DNSService dnsServer, DomainList domainList, MailQueueFactory queueFactory, MetricFactory metricFactory, THREAD_STATE startThreads) {
        this.dnsServer = dnsServer;
        this.domainList = domainList;
        this.queueFactory = queueFactory;
        this.metricFactory = metricFactory;
        this.isDestroyed = new AtomicBoolean(false);
        this.startThreads = startThreads;
    }

    public void init() throws MessagingException {
        this.logger = this.getMailetContext().getLogger();
        this.configuration = new RemoteDeliveryConfiguration(this.getMailetConfig(), this.domainList);
        this.queue = this.queueFactory.getQueue(this.configuration.getOutGoingQueueName());
        try {
            if (this.configuration.isBindUsed()) {
                RemoteDeliverySocketFactory.setBindAdress(this.configuration.getBindAddress());
            }
        }
        catch (UnknownHostException e) {
            this.log("Invalid bind setting (" + this.configuration.getBindAddress() + "): " + e.toString());
        }
        if (this.startThreads == THREAD_STATE.START_THREADS) {
            this.initDeliveryThreads();
        }
    }

    private void initDeliveryThreads() {
        this.executor = Executors.newFixedThreadPool(this.configuration.getWorkersThreadCount());
        for (int a = 0; a < this.configuration.getWorkersThreadCount(); ++a) {
            this.executor.execute(new DeliveryRunnable(this.queue, this.configuration, this.dnsServer, this.metricFactory, this.logger, this.getMailetContext(), new Bouncer(this.configuration, this.getMailetContext(), this.logger), this.isDestroyed));
        }
    }

    public String getMailetInfo() {
        return "RemoteDelivery Mailet";
    }

    public void service(Mail mail) throws MessagingException {
        if (this.configuration.isDebug()) {
            this.log("Remotely delivering mail " + mail.getName());
        }
        if (this.configuration.isUsePriority()) {
            mail.setAttribute("MAIL_PRIORITY", (Serializable)Integer.valueOf(9));
        }
        if (!mail.getRecipients().isEmpty()) {
            if (this.configuration.getGatewayServer().isEmpty()) {
                this.serviceNoGateway(mail);
            } else {
                this.serviceWithGateway(mail);
            }
        } else {
            this.log("Mail " + mail.getName() + " from " + mail.getSender() + " has no recipients and can not be remotely delivered");
        }
        mail.setState("ghost");
    }

    private void serviceWithGateway(Mail mail) {
        if (this.configuration.isDebug()) {
            this.log("Sending mail to " + mail.getRecipients() + " via " + this.configuration.getGatewayServer());
        }
        try {
            this.queue.enQueue(mail);
        }
        catch (MailQueue.MailQueueException e) {
            this.log("Unable to queue mail " + mail.getName() + " for recipients + " + mail.getRecipients().toString(), e);
        }
    }

    private void serviceNoGateway(Mail mail) {
        String mailName = mail.getName();
        Map<String, Collection<MailAddress>> targets = this.groupByServer(mail.getRecipients());
        for (Map.Entry<String, Collection<MailAddress>> entry : targets.entrySet()) {
            this.serviceSingleServer(mail, mailName, entry);
        }
    }

    private void serviceSingleServer(Mail mail, String originalName, Map.Entry<String, Collection<MailAddress>> entry) {
        if (this.configuration.isDebug()) {
            this.log("Sending mail to " + entry.getValue() + " on host " + entry.getKey());
        }
        mail.setRecipients(entry.getValue());
        mail.setName(originalName + NAME_JUNCTION + entry.getKey());
        try {
            this.queue.enQueue(mail);
        }
        catch (MailQueue.MailQueueException e) {
            this.log("Unable to queue mail " + mail.getName() + " for recipients + " + mail.getRecipients().toString(), e);
        }
    }

    private Map<String, Collection<MailAddress>> groupByServer(Collection<MailAddress> recipients) {
        HashMultimap groupByServerMultimap = HashMultimap.create();
        for (MailAddress recipient : recipients) {
            groupByServerMultimap.put((Object)recipient.getDomain().toLowerCase(Locale.US), (Object)recipient);
        }
        return groupByServerMultimap.asMap();
    }

    public synchronized void destroy() {
        if (this.startThreads == THREAD_STATE.START_THREADS) {
            this.isDestroyed.set(true);
            this.executor.shutdown();
            ((Object)((Object)this)).notifyAll();
        }
    }

    public static enum THREAD_STATE {
        START_THREADS,
        DO_NOT_START_THREADS;

    }
}

