/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;

@Experimental
public class RecoverAttachment
extends GenericMailet {
    public static final String ATTRIBUTE_PARAMETER_NAME = "attribute";
    private String attributeName = null;

    public void init() throws MailetException {
        this.attributeName = this.getInitParameter(ATTRIBUTE_PARAMETER_NAME);
        if (this.attributeName == null) {
            throw new MailetException("attribute is a mandatory parameter");
        }
        this.log("RecoverAttachment is initialised with attribute [" + this.attributeName + "]");
    }

    public void service(Mail mail) throws MailetException {
        Map attachments = (Map)((Object)mail.getAttribute(this.attributeName));
        if (attachments != null) {
            MimeMessage message;
            try {
                message = mail.getMessage();
            }
            catch (MessagingException e) {
                throw new MailetException("Could not retrieve message from Mail object", (Exception)((Object)e));
            }
            Iterator i = attachments.values().iterator();
            try {
                while (i.hasNext()) {
                    byte[] bytes = (byte[])i.next();
                    BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(bytes));
                    MimeBodyPart p = new MimeBodyPart((InputStream)is);
                    if (!message.isMimeType("multipart/*") || !(message.getContent() instanceof MimeMultipart)) {
                        Object content = message.getContent();
                        String contentType = message.getContentType();
                        MimeMultipart mimeMultipart = new MimeMultipart();
                        message.setContent((Multipart)mimeMultipart);
                        message.saveChanges();
                        mimeMultipart.setParent((Part)message);
                        MimeBodyPart bodyPart = new MimeBodyPart();
                        mimeMultipart.addBodyPart((BodyPart)bodyPart);
                        bodyPart.setContent(content, contentType);
                    }
                    ((MimeMultipart)message.getContent()).addBodyPart((BodyPart)p);
                }
                message.saveChanges();
            }
            catch (MessagingException e) {
                this.log("MessagingException in recoverAttachment", e);
            }
            catch (IOException e) {
                this.log("IOException in recoverAttachment", e);
            }
        }
    }

    public String getMailetInfo() {
        return "RecoverAttachment Mailet";
    }
}

