/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import java.util.Collection;
import java.util.Locale;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;

public class RecipientToLowerCase
extends GenericMailet {
    public static final Function<MailAddress, MailAddress> TO_LOWERCASE = new Function<MailAddress, MailAddress>(){

        public MailAddress apply(MailAddress input) {
            try {
                return new MailAddress(input.asString().toLowerCase(Locale.US));
            }
            catch (AddressException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };

    public void service(Mail mail) throws MessagingException {
        mail.setRecipients((Collection)FluentIterable.from((Iterable)mail.getRecipients()).transform(TO_LOWERCASE).toList());
    }
}

