/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.Mappings;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.MailetContext;

public class RecipientRewriteTableProcessor {
    private final RecipientRewriteTable virtualTableStore;
    private final DomainList domainList;
    private final MailetContext mailetContext;
    private static final Predicate<RrtExecutionResult> recipientWithError = new Predicate<RrtExecutionResult>(){

        public boolean apply(RrtExecutionResult mappingData) {
            return mappingData.isError();
        }
    };
    private static final Predicate<RrtExecutionResult> recipientWithoutError = new Predicate<RrtExecutionResult>(){

        public boolean apply(RrtExecutionResult mappingData) {
            return !mappingData.isError();
        }
    };
    private static final Predicate<Mapping> noneDomain = new Predicate<Mapping>(){

        public boolean apply(Mapping address) {
            return !address.hasDomain();
        }
    };
    private static final Predicate<Mapping> haveDomain = new Predicate<Mapping>(){

        public boolean apply(Mapping address) {
            return address.hasDomain();
        }
    };
    private static final Function<RrtExecutionResult, List<MailAddress>> mailAddressesFromMappingData = new Function<RrtExecutionResult, List<MailAddress>>(){

        public List<MailAddress> apply(RrtExecutionResult mappingData) {
            return (List)mappingData.getNewRecipients().or(mappingData.getRecipientWithError().or((Object)ImmutableList.of()));
        }
    };
    private static final Function<Optional<MailAddress>, MailAddress> mailAddressFromOptional = new Function<Optional<MailAddress>, MailAddress>(){

        public MailAddress apply(Optional<MailAddress> mailAddress) {
            return (MailAddress)mailAddress.get();
        }
    };
    private static final Predicate<Optional<MailAddress>> mailAddressPresent = new Predicate<Optional<MailAddress>>(){

        public boolean apply(Optional<MailAddress> mailAddress) {
            return mailAddress.isPresent();
        }
    };
    private static final Function<Mapping, Optional<MailAddress>> mailAddressFromMapping = new Function<Mapping, Optional<MailAddress>>(){

        public Optional<MailAddress> apply(Mapping addressMapping) {
            try {
                return Optional.of((Object)new MailAddress(addressMapping.asString()));
            }
            catch (AddressException e) {
                return Optional.absent();
            }
        }
    };

    public RecipientRewriteTableProcessor(RecipientRewriteTable virtualTableStore, DomainList domainList, MailetContext mailetContext) {
        this.virtualTableStore = virtualTableStore;
        this.domainList = domainList;
        this.mailetContext = mailetContext;
    }

    public void processMail(Mail mail) throws MessagingException {
        ImmutableList<RrtExecutionResult> mappingDatas = this.toMappingDatas(mail);
        ImmutableList<MailAddress> newRecipients = this.getRecipientsByCondition(mappingDatas, recipientWithoutError);
        ImmutableList<MailAddress> errorMailAddresses = this.getRecipientsByCondition(mappingDatas, recipientWithError);
        if (!errorMailAddresses.isEmpty()) {
            this.mailetContext.sendMail(mail.getSender(), errorMailAddresses, mail.getMessage(), "error");
        }
        if (newRecipients.isEmpty()) {
            mail.setState("ghost");
        }
        mail.setRecipients(newRecipients);
    }

    private ImmutableList<MailAddress> getRecipientsByCondition(ImmutableList<RrtExecutionResult> mappingDatas, Predicate<RrtExecutionResult> filterCondition) {
        return FluentIterable.from(mappingDatas).filter(filterCondition).transformAndConcat(mailAddressesFromMappingData).toList();
    }

    private ImmutableList<RrtExecutionResult> toMappingDatas(final Mail mail) {
        Function<MailAddress, RrtExecutionResult> convertToMappingData = new Function<MailAddress, RrtExecutionResult>(){

            public RrtExecutionResult apply(MailAddress recipient) {
                Preconditions.checkNotNull((Object)recipient);
                return RecipientRewriteTableProcessor.this.getRrtExecutionResult(mail, recipient);
            }
        };
        return FluentIterable.from((Iterable)mail.getRecipients()).transform((Function)convertToMappingData).toList();
    }

    private RrtExecutionResult getRrtExecutionResult(Mail mail, MailAddress recipient) {
        try {
            Mappings mappings = this.virtualTableStore.getMappings(recipient.getLocalPart(), recipient.getDomain());
            if (mappings != null) {
                List<MailAddress> newMailAddresses = this.handleMappings(mappings, mail.getSender(), recipient, mail.getMessage());
                return new RrtExecutionResult((Optional<List<MailAddress>>)Optional.of(newMailAddresses), (Optional<List<MailAddress>>)Optional.absent());
            }
            return this.origin(recipient);
        }
        catch (RecipientRewriteTable.ErrorMappingException e) {
            this.mailetContext.log(MailetContext.LogLevel.INFO, "Error while process mail.", (Throwable)e);
            return this.error(recipient);
        }
        catch (RecipientRewriteTableException e) {
            this.mailetContext.log(MailetContext.LogLevel.INFO, "Error while process mail.", (Throwable)e);
            return this.error(recipient);
        }
        catch (MessagingException e) {
            this.mailetContext.log(MailetContext.LogLevel.INFO, "Error while process mail.", (Throwable)e);
            return this.error(recipient);
        }
    }

    @VisibleForTesting
    List<MailAddress> handleMappings(Mappings mappings, MailAddress sender, MailAddress recipient, MimeMessage message) throws MessagingException {
        ImmutableList<Mapping> addressMappingWithoutDomains = this.getAddressWithNoDomain(mappings, this.domainList);
        ImmutableList<Mapping> newAddressMappings = this.convertToNewMappings(mappings, addressMappingWithoutDomains);
        ImmutableList<MailAddress> mailAddresses = this.buildMailAddressFromMappingAddress(newAddressMappings);
        this.forwardToRemoteAddress(sender, recipient, message, mailAddresses);
        return this.getLocalAddresses(mailAddresses);
    }

    private ImmutableList<Mapping> convertToNewMappings(Mappings mappings, ImmutableList<Mapping> addressWithoutDomains) {
        return FluentIterable.from((Iterable)mappings).filter(haveDomain).append(addressWithoutDomains).toList();
    }

    private ImmutableList<MailAddress> getLocalAddresses(ImmutableList<MailAddress> mailAddresses) {
        return FluentIterable.from(mailAddresses).filter(this.isLocalServer()).toList();
    }

    private ImmutableList<MailAddress> buildMailAddressFromMappingAddress(ImmutableList<Mapping> newMappings) {
        return FluentIterable.from(newMappings).transform(mailAddressFromMapping).filter(mailAddressPresent).transform(mailAddressFromOptional).toList();
    }

    private ImmutableList<Mapping> getAddressWithNoDomain(Mappings mappings, DomainList domainList) throws MessagingException {
        ImmutableList addressWithoutDomains = FluentIterable.from((Iterable)mappings).filter(noneDomain).toList();
        if (!addressWithoutDomains.isEmpty()) {
            String defaultDomain = this.getDefaultDomain(domainList);
            return FluentIterable.from((Iterable)addressWithoutDomains).transform(this.appendDefaultDomain(defaultDomain)).toList();
        }
        return ImmutableList.of();
    }

    private Function<Mapping, Mapping> appendDefaultDomain(final String defaultDomain) {
        return new Function<Mapping, Mapping>(){

            public Mapping apply(Mapping address) {
                return address.appendDomain(defaultDomain);
            }
        };
    }

    private Predicate<MailAddress> isLocalServer() {
        return new Predicate<MailAddress>(){

            public boolean apply(MailAddress mailAddress) {
                return RecipientRewriteTableProcessor.this.mailetContext.isLocalServer(mailAddress.getDomain());
            }
        };
    }

    private Predicate<MailAddress> isNotLocalServer() {
        return new Predicate<MailAddress>(){

            public boolean apply(MailAddress mailAddress) {
                return !RecipientRewriteTableProcessor.this.mailetContext.isLocalServer(mailAddress.getDomain());
            }
        };
    }

    private void forwardToRemoteAddress(MailAddress sender, MailAddress recipient, MimeMessage message, ImmutableList<MailAddress> mailAddresses) throws MessagingException {
        ImmutableList remoteAddress = FluentIterable.from(mailAddresses).filter(this.isNotLocalServer()).toList();
        if (!remoteAddress.isEmpty()) {
            try {
                this.mailetContext.sendMail(sender, (Collection)remoteAddress, message);
                this.mailetContext.log(MailetContext.LogLevel.INFO, "Mail for " + recipient + " forwarded to " + remoteAddress);
            }
            catch (MessagingException ex) {
                this.mailetContext.log(MailetContext.LogLevel.WARN, "Error forwarding mail to " + remoteAddress);
            }
        }
    }

    private String getDefaultDomain(DomainList domainList) throws MessagingException {
        try {
            return domainList.getDefaultDomain();
        }
        catch (DomainListException e) {
            throw new MessagingException("Unable to access DomainList", (Exception)((Object)e));
        }
    }

    private RrtExecutionResult error(MailAddress mailAddress) {
        return new RrtExecutionResult((Optional<List<MailAddress>>)Optional.absent(), (Optional<List<MailAddress>>)Optional.of((Object)ImmutableList.of((Object)mailAddress)));
    }

    private RrtExecutionResult origin(MailAddress mailAddress) {
        return new RrtExecutionResult((Optional<List<MailAddress>>)Optional.of((Object)ImmutableList.of((Object)mailAddress)), (Optional<List<MailAddress>>)Optional.absent());
    }

    class RrtExecutionResult {
        private final Optional<List<MailAddress>> newRecipients;
        private final Optional<List<MailAddress>> recipientWithError;

        public RrtExecutionResult(Optional<List<MailAddress>> newRecipients, Optional<List<MailAddress>> recipientWithError) {
            this.newRecipients = newRecipients;
            this.recipientWithError = recipientWithError;
        }

        public Optional<List<MailAddress>> getNewRecipients() {
            return this.newRecipients;
        }

        public Optional<List<MailAddress>> getRecipientWithError() {
            return this.recipientWithError;
        }

        public boolean isError() {
            return this.recipientWithError.isPresent();
        }
    }
}

