/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.transport.mailets.redirect.AddressExtractor;
import org.apache.james.transport.mailets.redirect.InitParameters;
import org.apache.james.transport.mailets.redirect.NotifyMailetInitParameters;
import org.apache.james.transport.mailets.redirect.NotifyMailetsMessage;
import org.apache.james.transport.mailets.redirect.ProcessRedirectNotify;
import org.apache.james.transport.mailets.redirect.RedirectNotify;
import org.apache.james.transport.mailets.redirect.SpecialAddress;
import org.apache.james.transport.mailets.utils.MimeMessageModifier;
import org.apache.james.transport.mailets.utils.MimeMessageUtils;
import org.apache.james.transport.util.RecipientsUtils;
import org.apache.james.transport.util.ReplyToUtils;
import org.apache.james.transport.util.SenderUtils;
import org.apache.james.transport.util.SpecialAddressesUtils;
import org.apache.james.transport.util.TosUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.GenericMailet;

public class NotifySender
extends GenericMailet
implements RedirectNotify {
    private static final String[] CONFIGURABLE_PARAMETERS = new String[]{"debug", "passThrough", "fakeDomainCheck", "inline", "attachment", "message", "notice", "sender", "sendingAddress", "prefix", "attachError", "to"};
    private static final List<MailAddress> RECIPIENT_MAIL_ADDRESSES = ImmutableList.of((Object)SpecialAddress.SENDER);
    private static final List<String> ALLOWED_SPECIALS = ImmutableList.of((Object)"sender", (Object)"unaltered", (Object)"from");
    private final DNSService dns;
    private Optional<String> to = Optional.absent();

    @Inject
    public NotifySender(DNSService dns) {
        this.dns = dns;
    }

    public void init(MailetConfig mailetConfig) throws MessagingException {
        super.init(mailetConfig);
        this.to = Optional.fromNullable((Object)this.getInitParameter("to"));
    }

    public String getMailetInfo() {
        return "NotifySender Mailet";
    }

    @Override
    public InitParameters getInitParameters() {
        return NotifyMailetInitParameters.from(this);
    }

    @Override
    public String[] getAllowedInitParameters() {
        return CONFIGURABLE_PARAMETERS;
    }

    @Override
    public DNSService getDNSService() {
        return this.dns;
    }

    public void init() throws MessagingException {
        if (this.getInitParameters().isDebug()) {
            this.log("Initializing");
        }
        this.checkInitParameters(this.getAllowedInitParameters());
        if (this.getInitParameters().isStatic() && this.getInitParameters().isDebug()) {
            this.log(this.getInitParameters().asString());
        }
    }

    @Override
    public String getMessage(Mail originalMail) throws MessagingException {
        return new NotifyMailetsMessage().generateMessage(this.getInitParameters().getMessage(), originalMail);
    }

    @Override
    public List<MailAddress> getRecipients() {
        return RECIPIENT_MAIL_ADDRESSES;
    }

    @Override
    public List<MailAddress> getRecipients(Mail originalMail) throws MessagingException {
        return RecipientsUtils.from(this).getRecipients(originalMail);
    }

    @Override
    public List<InternetAddress> getTo() throws MessagingException {
        if (this.to.isPresent()) {
            Optional<MailAddress> specialAddress = AddressExtractor.withContext(this.getMailetContext()).allowedSpecials(ALLOWED_SPECIALS).getSpecialAddress((String)this.to.get());
            if (specialAddress.isPresent()) {
                return ImmutableList.of((Object)((MailAddress)specialAddress.get()).toInternetAddress());
            }
            this.log("\"to\" parameter ignored, set to sender");
        }
        return ImmutableList.of((Object)SpecialAddress.SENDER.toInternetAddress());
    }

    @Override
    public List<MailAddress> getTo(Mail originalMail) throws MessagingException {
        return TosUtils.from(this).getTo(originalMail);
    }

    @Override
    public Optional<MailAddress> getReplyTo() throws MessagingException {
        return Optional.of((Object)SpecialAddress.NULL);
    }

    @Override
    public Optional<MailAddress> getReplyTo(Mail originalMail) throws MessagingException {
        return ReplyToUtils.from(this.getReplyTo()).getReplyTo(originalMail);
    }

    @Override
    public Optional<MailAddress> getReversePath() throws MessagingException {
        return SpecialAddressesUtils.from(this).getFirstSpecialAddressIfMatchingOrGivenAddress(this.getInitParameters().getReversePath(), RedirectNotify.REVERSE_PATH_ALLOWED_SPECIALS);
    }

    @Override
    public Optional<MailAddress> getReversePath(Mail originalMail) throws MessagingException {
        return this.getSender(originalMail);
    }

    @Override
    public Optional<MailAddress> getSender() throws MessagingException {
        return SpecialAddressesUtils.from(this).getFirstSpecialAddressIfMatchingOrGivenAddress(this.getInitParameters().getSender(), RedirectNotify.SENDER_ALLOWED_SPECIALS);
    }

    @Override
    public Optional<MailAddress> getSender(Mail originalMail) throws MessagingException {
        return SenderUtils.from(this.getSender()).getSender(originalMail);
    }

    @Override
    public Optional<String> getSubjectPrefix(Mail newMail, String subjectPrefix, Mail originalMail) throws MessagingException {
        return new MimeMessageUtils(originalMail.getMessage()).subjectWithPrefix(subjectPrefix);
    }

    @Override
    public MimeMessageModifier getMimeMessageModifier(Mail newMail, Mail originalMail) throws MessagingException {
        return new MimeMessageModifier(originalMail.getMessage());
    }

    @Override
    public void service(Mail originalMail) throws MessagingException {
        ProcessRedirectNotify.from(this).process(originalMail);
    }
}

