/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class LogMessage
extends GenericMailet {
    private boolean passThrough = true;
    private boolean headers = true;
    private boolean body = true;
    private int bodyMax = 0;
    private String comment = null;

    public void init() {
        try {
            this.passThrough = this.getInitParameter("passThrough", true);
            this.headers = this.getInitParameter("headers", true);
            this.body = this.getInitParameter("body", true);
            this.bodyMax = this.getInitParameter("maxBody") == null ? 0 : Integer.parseInt(this.getInitParameter("maxBody"));
            this.comment = this.getInitParameter("comment");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getMailetInfo() {
        return "LogHeaders Mailet";
    }

    public void service(Mail mail) {
        this.log("Logging mail " + mail.getName());
        this.logComment();
        try {
            MimeMessage message = mail.getMessage();
            this.logHeaders(message);
            this.logBody(message);
        }
        catch (MessagingException e) {
            this.log("Error logging message.", e);
        }
        catch (IOException e) {
            this.log("Error logging message.", e);
        }
        if (!this.passThrough) {
            mail.setState("ghost");
        }
    }

    private void logComment() {
        if (this.comment != null) {
            this.log(this.comment);
        }
    }

    private void logHeaders(MimeMessage message) throws MessagingException {
        if (this.headers) {
            this.log("\n");
            for (String header : Collections.list(message.getAllHeaderLines())) {
                this.log(header + "\n");
            }
        }
    }

    private void logBody(MimeMessage message) throws MessagingException, IOException {
        if (this.body) {
            InputStream inputStream = ByteStreams.limit((InputStream)message.getRawInputStream(), (long)this.lengthToLog(message));
            this.log(IOUtils.toString((InputStream)inputStream));
        }
    }

    private int lengthToLog(MimeMessage message) throws MessagingException {
        return this.bodyMax > 0 ? this.bodyMax : message.getSize();
    }
}

