/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.sql.DataSource;
import org.apache.james.transport.mailets.AbstractRecipientRewriteTable;
import org.apache.james.util.sql.JDBCUtil;
import org.apache.mailet.Experimental;
import org.apache.mailet.MailAddress;
import org.apache.mailet.MailetException;

@Deprecated
@Experimental
public class JDBCRecipientRewriteTable
extends AbstractRecipientRewriteTable {
    protected DataSource datasource;
    protected String query = null;
    private final JDBCUtil theJDBCUtil = new JDBCUtil(){

        protected void delegatedLog(String logString) {
            JDBCRecipientRewriteTable.this.log("JDBCRecipientRewriteTable: " + logString);
        }
    };

    @Inject
    public void setDataSourceSelector(DataSource datasource) {
        this.datasource = datasource;
    }

    public void init() throws MessagingException {
        if (this.getInitParameter("table") == null) {
            throw new MailetException("Table location not specified for JDBCRecipientRewriteTable");
        }
        String tableURL = this.getInitParameter("table");
        String datasourceName = tableURL.substring(5);
        int pos = datasourceName.indexOf("/");
        String tableName = datasourceName.substring(pos + 1);
        datasourceName = datasourceName.substring(0, pos);
        Connection conn = null;
        try {
            conn = this.datasource.getConnection();
            DatabaseMetaData dbMetaData = conn.getMetaData();
            if (!this.theJDBCUtil.tableExists(dbMetaData, tableName)) {
                String exceptionBuffer = "Could not find table '" + tableName + "' in datasource '" + datasourceName + "'";
                throw new MailetException(exceptionBuffer);
            }
            this.query = this.getInitParameter("sqlquery", "select RecipientRewriteTable.target_address from RecipientRewriteTable, RecipientRewriteTable as VUTDomains where (RecipientRewriteTable.user like ? or RecipientRewriteTable.user like '\\%') and (RecipientRewriteTable.domain like ? or (RecipientRewriteTable.domain like '%*%' and VUTDomains.domain like ?)) order by concat(RecipientRewriteTable.user,'@',RecipientRewriteTable.domain) desc limit 1");
        }
        catch (MailetException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MessagingException("Error initializing JDBCRecipientRewriteTable", e);
        }
        finally {
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void mapRecipients(Map<MailAddress, String> recipientsMap) throws MessagingException {
        Connection conn = null;
        PreparedStatement mappingStmt = null;
        Set<MailAddress> recipients = recipientsMap.keySet();
        try {
            conn = this.datasource.getConnection();
            mappingStmt = conn.prepareStatement(this.query);
            for (MailAddress recipient : recipients) {
                ResultSet mappingRS = null;
                try {
                    mappingStmt.setString(1, recipient.getLocalPart());
                    mappingStmt.setString(2, recipient.getDomain());
                    mappingStmt.setString(3, recipient.getDomain());
                    mappingRS = mappingStmt.executeQuery();
                    if (mappingRS.next()) {
                        String targetString = mappingRS.getString(1);
                        recipientsMap.put(recipient, targetString);
                    }
                }
                catch (Throwable throwable) {
                    this.theJDBCUtil.closeJDBCResultSet(mappingRS);
                    throw throwable;
                }
                this.theJDBCUtil.closeJDBCResultSet(mappingRS);
            }
        }
        catch (SQLException sqle) {
            try {
                throw new MessagingException("Error accessing database", (Exception)sqle);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
    }

    public String getMailetInfo() {
        return "JDBC Virtual User Table mailet";
    }
}

