/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Vector;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.ParseException;
import javax.sql.DataSource;
import org.apache.james.util.sql.JDBCUtil;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;

@Experimental
public class JDBCAlias
extends GenericMailet {
    protected DataSource datasource;
    protected String query = null;
    private final JDBCUtil theJDBCUtil = new JDBCUtil(){

        protected void delegatedLog(String logString) {
            JDBCAlias.this.log("JDBCAlias: " + logString);
        }
    };

    @Inject
    public void setDataSource(DataSource datasource) {
        this.datasource = datasource;
    }

    public void init() throws MessagingException {
        String mappingsURL = this.getInitParameter("mappings");
        String datasourceName = mappingsURL.substring(5);
        int pos = datasourceName.indexOf("/");
        String tableName = datasourceName.substring(pos + 1);
        datasourceName = datasourceName.substring(0, pos);
        Connection conn = null;
        if (this.getInitParameter("source_column") == null) {
            throw new MailetException("source_column not specified for JDBCAlias");
        }
        if (this.getInitParameter("target_column") == null) {
            throw new MailetException("target_column not specified for JDBCAlias");
        }
        try {
            conn = this.datasource.getConnection();
            DatabaseMetaData dbMetaData = conn.getMetaData();
            if (!this.theJDBCUtil.tableExists(dbMetaData, tableName)) {
                String exceptionBuffer = "Could not find table '" + tableName + "' in datasource '" + datasourceName + "'";
                throw new MailetException(exceptionBuffer);
            }
            this.query = "SELECT " + this.getInitParameter("target_column") + " FROM " + tableName + " WHERE " + this.getInitParameter("source_column") + " = ?";
        }
        catch (MailetException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MessagingException("Error initializing JDBCAlias", e);
        }
        finally {
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Mail mail) throws MessagingException {
        Connection conn = null;
        PreparedStatement mappingStmt = null;
        ResultSet mappingRS = null;
        Collection recipients = mail.getRecipients();
        Vector<MailAddress> recipientsToRemove = new Vector<MailAddress>();
        Vector<MailAddress> recipientsToAdd = new Vector<MailAddress>();
        try {
            conn = this.datasource.getConnection();
            mappingStmt = conn.prepareStatement(this.query);
            for (MailAddress recipient : recipients) {
                try {
                    mappingStmt.setString(1, recipient.toString());
                    mappingRS = mappingStmt.executeQuery();
                    if (!mappingRS.next()) continue;
                    try {
                        String targetString = mappingRS.getString(1);
                        MailAddress target = new MailAddress(targetString);
                        recipientsToRemove.add(recipient);
                        recipientsToAdd.add(target);
                    }
                    catch (ParseException pe) {
                        String exceptionBuffer = "There is an invalid alias from " + recipient + " to " + mappingRS.getString(1);
                        this.log(exceptionBuffer);
                    }
                }
                finally {
                    ResultSet localRS = mappingRS;
                    mappingRS = null;
                    this.theJDBCUtil.closeJDBCResultSet(localRS);
                }
            }
        }
        catch (SQLException sqle) {
            try {
                throw new MessagingException("Error accessing database", (Exception)sqle);
            }
            catch (Throwable throwable) {
                this.theJDBCUtil.closeJDBCStatement(mappingStmt);
                this.theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)mappingStmt);
        this.theJDBCUtil.closeJDBCConnection(conn);
        recipients.removeAll(recipientsToRemove);
        recipients.addAll(recipientsToAdd);
    }

    public String getMailetInfo() {
        return "JDBC aliasing mailet";
    }
}

