/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

@Experimental
public class HeadersToHTTP
extends GenericMailet {
    private String url;
    private String parameterKey = null;
    private String parameterValue = null;
    private boolean passThrough = true;

    public void init() throws MessagingException {
        this.passThrough = this.getInitParameter("passThrough", "true").compareToIgnoreCase("true") == 0;
        String targetUrl = this.getInitParameter("url");
        this.parameterKey = this.getInitParameter("parameterKey");
        this.parameterValue = this.getInitParameter("parameterValue");
        if (targetUrl == null || targetUrl.equals("")) {
            throw new MessagingException("Please configure a targetUrl (\"url\")");
        }
        try {
            this.url = new URL(targetUrl).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new MessagingException("Unable to contruct URL object from url");
        }
        this.log("I will attempt to deliver serialised messages to " + targetUrl + ". " + (this.parameterKey == null || this.parameterKey.length() < 1 ? "I will not add any fields to the post. " : "I will prepend: " + this.parameterKey + "=" + this.parameterValue + ". ") + (this.passThrough ? "Messages will pass through." : "Messages will be ghosted."));
    }

    public void service(Mail mail) {
        try {
            this.log(mail.getName() + "HeadersToHTTP: Starting");
            MimeMessage message = mail.getMessage();
            HashSet<NameValuePair> pairs = this.getNameValuePairs(message);
            this.log(mail.getName() + "HeadersToHTTP: " + pairs.size() + " named value pairs found");
            String result = this.httpPost(pairs);
            if (this.passThrough) {
                this.addHeader(mail, true, result);
            } else {
                mail.setState("ghost");
            }
        }
        catch (MessagingException me) {
            this.log(me.getMessage());
            this.addHeader(mail, false, me.getMessage());
        }
        catch (IOException e) {
            this.log(e.getMessage());
            this.addHeader(mail, false, e.getMessage());
        }
    }

    private void addHeader(Mail mail, boolean success, String errorMessage) {
        try {
            MimeMessage message = mail.getMessage();
            message.setHeader("X-headerToHTTP", success ? "Succeeded" : "Failed");
            if (!success && errorMessage != null && errorMessage.length() > 0) {
                message.setHeader("X-headerToHTTPFailure", errorMessage);
            }
            message.saveChanges();
        }
        catch (MessagingException e) {
            this.log(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String httpPost(HashSet<NameValuePair> pairs) throws IOException {
        String string;
        CloseableHttpClient client = null;
        CloseableHttpResponse clientResponse = null;
        try {
            client = HttpClientBuilder.create().build();
            HttpUriRequest request = RequestBuilder.post((String)this.url).addParameters(pairs.toArray(new NameValuePair[0])).build();
            clientResponse = client.execute(request);
            String result = clientResponse.getStatusLine().getStatusCode() + ": " + clientResponse.getStatusLine();
            this.log("HeadersToHTTP: " + result);
            string = result;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(clientResponse);
            IOUtils.closeQuietly((Closeable)client);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)clientResponse);
        IOUtils.closeQuietly((Closeable)client);
        return string;
    }

    private HashSet<NameValuePair> getNameValuePairs(MimeMessage message) throws UnsupportedEncodingException, MessagingException {
        HashSet<NameValuePair> pairs = new HashSet<NameValuePair>();
        if (message != null) {
            if (message.getSender() != null) {
                pairs.add((NameValuePair)new BasicNameValuePair("from", message.getSender().toString()));
            }
            if (message.getReplyTo() != null) {
                pairs.add((NameValuePair)new BasicNameValuePair("reply_to", Arrays.toString(message.getReplyTo())));
            }
            if (message.getMessageID() != null) {
                pairs.add((NameValuePair)new BasicNameValuePair("message_id", message.getMessageID()));
            }
            if (message.getSubject() != null) {
                pairs.add((NameValuePair)new BasicNameValuePair("subject", message.getSubject()));
            }
            pairs.add((NameValuePair)new BasicNameValuePair("size", Integer.toString(message.getSize())));
        }
        pairs.add((NameValuePair)new BasicNameValuePair(this.parameterKey, this.parameterValue));
        return pairs;
    }

    public String getMailetInfo() {
        return "HTTP POST serialised message";
    }
}

