/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

@Experimental
public class FromRepository
extends GenericMailet {
    private MailRepository repository;
    private boolean delete = false;
    private String repositoryPath;
    private String processor;
    private MailRepositoryStore mailStore;

    @Inject
    public void setStore(MailRepositoryStore mailStore) {
        this.mailStore = mailStore;
    }

    public void init() throws MessagingException {
        this.repositoryPath = this.getInitParameter("repositoryPath");
        this.processor = this.getInitParameter("processor") == null ? "root" : this.getInitParameter("processor");
        try {
            this.delete = this.getInitParameter("delete") == null ? false : Boolean.valueOf(this.getInitParameter("delete"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.repository = this.mailStore.select(this.repositoryPath);
        }
        catch (Exception e) {
            throw new MessagingException("Failed to retrieve MailRepository for url " + this.repositoryPath, e);
        }
    }

    public void service(Mail trigger) throws MessagingException {
        trigger.setState("ghost");
        ArrayList<String> processed = new ArrayList<String>();
        Iterator list = this.repository.list();
        while (list.hasNext()) {
            String key = (String)list.next();
            try {
                Mail mail = this.repository.retrieve(key);
                if (mail == null || mail.getRecipients() == null) continue;
                this.log(new StringBuffer(160).append("Spooling mail ").append(mail.getName()).append(" from ").append(this.repositoryPath).toString());
                mail.setAttribute("FromRepository", (Serializable)Boolean.TRUE);
                mail.setState(this.processor);
                this.getMailetContext().sendMail(mail);
                if (this.delete) {
                    processed.add(key);
                }
                LifecycleUtil.dispose((Object)mail);
            }
            catch (MessagingException messagingException) {
                this.log(new StringBuffer(160).append("Unable to re-spool mail ").append(key).append(" from ").append(this.repositoryPath).toString(), messagingException);
            }
        }
        if (this.delete) {
            for (Object e : processed) {
                this.repository.remove((String)e);
            }
        }
    }

    public String getMailetInfo() {
        return "FromRepository Mailet";
    }
}

