/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.inject.Inject;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.sql.DataSource;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.util.bayesian.JDBCBayesianAnalyzer;
import org.apache.james.util.sql.JDBCUtil;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

@Experimental
public class BayesianAnalysisFeeder
extends GenericMailet {
    private final JDBCUtil theJDBCUtil = new JDBCUtil(){

        protected void delegatedLog(String logString) {
            BayesianAnalysisFeeder.this.log("BayesianAnalysisFeeder: " + logString);
        }
    };
    private final JDBCBayesianAnalyzer analyzer = new JDBCBayesianAnalyzer(){

        protected void delegatedLog(String logString) {
            BayesianAnalysisFeeder.this.log("BayesianAnalysisFeeder: " + logString);
        }
    };
    private DataSource datasource;
    private String feedType;
    private int maxSize = 100000;
    private FileSystem fs;

    public String getMailetInfo() {
        return "BayesianAnalysisFeeder Mailet";
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Inject
    public void setDataSource(DataSource datasource) {
        this.datasource = datasource;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Inject
    public void setFileSystem(FileSystem fs) {
        this.fs = fs;
    }

    public void init() throws MessagingException {
        String repositoryPath = this.getInitParameter("repositoryPath");
        if (repositoryPath == null) {
            throw new MessagingException("repositoryPath is null");
        }
        this.feedType = this.getInitParameter("feedType");
        if (this.feedType == null) {
            throw new MessagingException("feedType is null");
        }
        String maxSizeParam = this.getInitParameter("maxSize");
        if (maxSizeParam != null) {
            this.setMaxSize(Integer.parseInt(maxSizeParam));
        }
        this.log("maxSize: " + this.getMaxSize());
        this.initDb();
    }

    private void initDb() throws MessagingException {
        try {
            this.analyzer.initSqlQueries(this.datasource.getConnection(), this.fs.getFile("file://conf/sqlResources.xml"));
        }
        catch (Exception e) {
            throw new MessagingException("Exception initializing queries", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Mail mail) {
        boolean dbUpdated = false;
        mail.setState("ghost");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Connection conn = null;
        try {
            MimeMessage message = mail.getMessage();
            String messageId = message.getMessageID();
            if (message.getSize() > this.getMaxSize()) {
                this.log(messageId + " Feeding HAM/SPAM ignored because message size > " + this.getMaxSize() + ": " + message.getSize());
                return;
            }
            this.clearAllHeaders(message);
            message.writeTo((OutputStream)baos);
            BufferedReader br = new BufferedReader(new StringReader(baos.toString()));
            String string = "database lock";
            synchronized ("database lock") {
                conn = this.datasource.getConnection();
                if (conn.getAutoCommit()) {
                    conn.setAutoCommit(false);
                }
                dbUpdated = true;
                this.analyzer.clear();
                if ("ham".equalsIgnoreCase(this.feedType)) {
                    this.log(messageId + " Feeding HAM");
                    this.analyzer.addHam((Reader)br);
                    this.analyzer.updateHamTokens(conn);
                } else {
                    this.log(messageId + " Feeding SPAM");
                    this.analyzer.addSpam((Reader)br);
                    this.analyzer.updateSpamTokens(conn);
                }
                if (conn != null && dbUpdated && !conn.getAutoCommit()) {
                    conn.commit();
                    dbUpdated = false;
                    this.log(messageId + " Training ended successfully");
                    JDBCBayesianAnalyzer.touchLastDatabaseUpdateTime();
                }
                // ** MonitorExit[var8_16] (shouldn't be in output)
            }
        }
        catch (SQLException se) {
            this.log("SQLException: " + se.getMessage());
        }
        catch (IOException ioe) {
            this.log("IOException: " + ioe.getMessage());
        }
        catch (MessagingException me) {
            this.log("MessagingException: " + me.getMessage());
        }
        finally {
            try {
                if (conn != null && dbUpdated && !conn.getAutoCommit()) {
                    conn.rollback();
                    dbUpdated = false;
                }
            }
            catch (Exception se) {}
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
        {
            return;
        }
    }

    private void clearAllHeaders(MimeMessage message) throws MessagingException {
        Enumeration headers = message.getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            try {
                message.removeHeader(header.getName());
            }
            catch (MessagingException messagingException) {}
        }
        message.saveChanges();
    }
}

