/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.ParseException;
import org.apache.james.core.MailImpl;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.rrt.lib.RecipientRewriteTableUtil;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMailet;

@Deprecated
@Experimental
public abstract class AbstractRecipientRewriteTable
extends GenericMailet {
    private static final String MARKER = "org.apache.james.transport.mailets.AbstractRecipientRewriteTable.mapped";
    private DNSService dns;
    private DomainList domainList;

    @Inject
    public void setDNSService(DNSService dns) {
        this.dns = dns;
    }

    @Inject
    public void setDomainList(DomainList domainList) {
        this.domainList = domainList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Mail mail) throws MessagingException {
        if (mail.getAttribute(MARKER) != null) {
            mail.removeAttribute(MARKER);
            return;
        }
        HashSet<MailAddress> recipientsToRemove = new HashSet<MailAddress>();
        ArrayList<MailAddress> recipientsToAddLocal = new ArrayList<MailAddress>();
        ArrayList<MailAddress> recipientsToAddForward = new ArrayList<MailAddress>();
        Collection recipients = mail.getRecipients();
        HashMap<MailAddress, String> recipientsMap = new HashMap<MailAddress, String>(recipients.size());
        for (MailAddress address : recipients) {
            recipientsMap.put(address, null);
        }
        this.mapRecipients(recipientsMap);
        for (MailAddress source : recipientsMap.keySet()) {
            String targetString = (String)recipientsMap.get(source);
            if (targetString == null) continue;
            if (targetString.startsWith("error:")) {
                recipientsToRemove.add(source);
                this.processDSN(mail, source, targetString);
                continue;
            }
            StringTokenizer tokenizer = new StringTokenizer(targetString, this.getSeparator(targetString));
            while (tokenizer.hasMoreTokens()) {
                String targetAddress = tokenizer.nextToken().trim();
                if (targetAddress.startsWith("regex:")) {
                    try {
                        targetAddress = RecipientRewriteTableUtil.regexMap((MailAddress)source, (String)targetAddress);
                    }
                    catch (PatternSyntaxException e) {
                        this.log("Exception during regexMap processing: ", e);
                    }
                    if (targetAddress == null) continue;
                }
                try {
                    MailAddress target = targetAddress.indexOf(64) < 0 ? new MailAddress(targetAddress, this.domainList.getDefaultDomain()) : new MailAddress(targetAddress);
                    recipientsToRemove.add(source);
                    if (this.getMailetContext().isLocalServer(target.getDomain())) {
                        recipientsToAddLocal.add(target);
                    } else {
                        recipientsToAddForward.add(target);
                    }
                    String buf = "Translating virtual user " + source + " to " + target;
                    this.log(buf);
                }
                catch (ParseException pe) {
                    String exceptionBuffer = "There is an invalid map from " + source + " to " + targetAddress;
                    this.log(exceptionBuffer);
                }
                catch (DomainListException e) {
                    this.log("Unable to access DomainList", e);
                }
            }
        }
        recipients.removeAll(recipientsToRemove);
        recipients.addAll(recipientsToAddLocal);
        if (recipientsToAddForward.size() != 0) {
            MailImpl newMail = new MailImpl(mail);
            try {
                try {
                    newMail.setRemoteAddr(this.dns.getLocalHost().getHostAddress());
                }
                catch (UnknownHostException e) {
                    newMail.setRemoteAddr("127.0.0.1");
                }
                try {
                    newMail.setRemoteHost(this.dns.getLocalHost().getHostName());
                }
                catch (UnknownHostException e) {
                    newMail.setRemoteHost("localhost");
                }
                newMail.setRecipients(recipientsToAddForward);
                newMail.setAttribute(MARKER, (Serializable)Boolean.TRUE);
                this.getMailetContext().sendMail((Mail)newMail);
            }
            finally {
                newMail.dispose();
            }
        }
        if (recipients.size() == 0) {
            mail.setState("ghost");
        }
    }

    protected abstract void mapRecipients(Map<MailAddress, String> var1) throws MessagingException;

    private void processDSN(Mail mail, MailAddress address, String error) {
        int msgPos = error.indexOf(32);
        try {
            Integer n = Integer.valueOf(error.substring("error:".length(), msgPos));
        }
        catch (NumberFormatException e) {
            this.log("Cannot send DSN.  Exception parsing DSN code from: " + error, e);
            return;
        }
        String msg = error.substring(msgPos + 1);
        try {
            this.getMailetContext().bounce(mail, error);
        }
        catch (MessagingException me) {
            this.log("Cannot send DSN.  Exception during DSN processing: ", me);
        }
    }

    private String getSeparator(String targetString) {
        return targetString.indexOf(44) > -1 ? "," : (targetString.indexOf(59) > -1 ? ";" : (targetString.contains("regex:") ? "" : ":"));
    }
}

