/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.james.core.MimeMessageSource;
import org.apache.james.mailrepository.jdbc.JDBCMailRepository;
import org.apache.james.repository.api.StreamRepository;
import org.apache.james.repository.file.FilePersistentStreamRepository;
import org.apache.james.util.sql.JDBCUtil;

public class MimeMessageJDBCSource
extends MimeMessageSource {
    private static final boolean DEEP_DEBUG = false;
    JDBCMailRepository repository = null;
    String key = null;
    StreamRepository sr = null;
    private long size = -1L;
    String retrieveMessageBodySQL = null;
    String retrieveMessageBodySizeSQL = null;
    private static final JDBCUtil theJDBCUtil = new JDBCUtil(){

        protected void delegatedLog(String logString) {
        }
    };

    public MimeMessageJDBCSource(JDBCMailRepository repository, String key, StreamRepository sr) throws IOException {
        if (repository == null) {
            throw new IOException("Repository is null");
        }
        if (key == null) {
            throw new IOException("Message name (key) was not defined");
        }
        this.repository = repository;
        this.key = key;
        this.sr = sr;
        this.retrieveMessageBodySQL = repository.sqlQueries.getSqlString("retrieveMessageBodySQL", true);
        this.retrieveMessageBodySizeSQL = repository.sqlQueries.getSqlString("retrieveMessageBodySizeSQL");
    }

    public String getSourceId() {
        return this.repository.repositoryName + "/" + this.key;
    }

    public synchronized InputStream getInputStream() throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        Connection conn = null;
        PreparedStatement retrieveMessageStream = null;
        ResultSet rsRetrieveMessageStream = null;
        try {
            byte[] headers;
            conn = this.repository.getConnection();
            long start = 0L;
            retrieveMessageStream = conn.prepareStatement(this.retrieveMessageBodySQL);
            retrieveMessageStream.setString(1, this.key);
            retrieveMessageStream.setString(2, this.repository.repositoryName);
            rsRetrieveMessageStream = retrieveMessageStream.executeQuery();
            if (!rsRetrieveMessageStream.next()) {
                throw new IOException("Could not find message");
            }
            String getBodyOption = this.repository.sqlQueries.getDbOption("getBody");
            if (getBodyOption != null && getBodyOption.equalsIgnoreCase("useBlob")) {
                Blob b = rsRetrieveMessageStream.getBlob(1);
                headers = b.getBytes(1L, (int)b.length());
            } else {
                headers = rsRetrieveMessageStream.getBytes(1);
            }
            InputStream in = new ByteArrayInputStream(headers);
            try {
                if (this.sr != null) {
                    in = new SequenceInputStream(in, this.sr.get(this.key));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            byteArrayInputStream = in;
        }
        catch (SQLException sqle) {
            try {
                throw new IOException(sqle.toString());
            }
            catch (Throwable throwable) {
                theJDBCUtil.closeJDBCResultSet(rsRetrieveMessageStream);
                theJDBCUtil.closeJDBCStatement(retrieveMessageStream);
                theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        theJDBCUtil.closeJDBCResultSet(rsRetrieveMessageStream);
        theJDBCUtil.closeJDBCStatement((Statement)retrieveMessageStream);
        theJDBCUtil.closeJDBCConnection(conn);
        return byteArrayInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getMessageSize() throws IOException {
        long l;
        if (this.size != -1L) {
            return this.size;
        }
        if (this.retrieveMessageBodySizeSQL == null) {
            System.err.println("no SQL statement to find size");
            this.size = super.getMessageSize();
            return this.size;
        }
        Connection conn = null;
        PreparedStatement retrieveMessageSize = null;
        ResultSet rsRetrieveMessageSize = null;
        try {
            conn = this.repository.getConnection();
            retrieveMessageSize = conn.prepareStatement(this.retrieveMessageBodySizeSQL);
            retrieveMessageSize.setString(1, this.key);
            retrieveMessageSize.setString(2, this.repository.repositoryName);
            rsRetrieveMessageSize = retrieveMessageSize.executeQuery();
            if (!rsRetrieveMessageSize.next()) {
                throw new IOException("Could not find message");
            }
            this.size = rsRetrieveMessageSize.getLong(1);
            InputStream in = null;
            try {
                if (this.sr != null) {
                    if (this.sr instanceof FilePersistentStreamRepository) {
                        this.size += ((FilePersistentStreamRepository)this.sr).getSize(this.key);
                    } else {
                        int len;
                        in = this.sr.get(this.key);
                        byte[] block = new byte[1024];
                        while ((len = in.read(block)) > -1) {
                            this.size += (long)len;
                        }
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
            l = this.size;
        }
        catch (SQLException sqle) {
            try {
                throw new IOException(sqle.toString());
            }
            catch (Throwable throwable) {
                theJDBCUtil.closeJDBCResultSet(rsRetrieveMessageSize);
                theJDBCUtil.closeJDBCStatement(retrieveMessageSize);
                theJDBCUtil.closeJDBCConnection(conn);
                throw throwable;
            }
        }
        theJDBCUtil.closeJDBCResultSet(rsRetrieveMessageSize);
        theJDBCUtil.closeJDBCStatement((Statement)retrieveMessageSize);
        theJDBCUtil.closeJDBCConnection(conn);
        return l;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MimeMessageJDBCSource) {
            MimeMessageJDBCSource source = (MimeMessageJDBCSource)((Object)obj);
            return (source.key.equals(this.key) || source.key != null && source.key.equals(this.key)) && (source.repository == this.repository || source.repository != null && source.repository.equals((Object)this.repository));
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        if (this.key != null) {
            result = 37 * this.key.hashCode();
        }
        if (this.repository != null) {
            result = 37 * this.repository.hashCode();
        }
        return result;
    }
}

