/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.mailetcontainer.api.MailProcessor;
import org.apache.james.mailetcontainer.api.MailetLoader;
import org.apache.james.mailetcontainer.api.MatcherLoader;
import org.apache.james.mailetcontainer.impl.MailetConfigImpl;
import org.apache.james.mailetcontainer.impl.MatcherConfigImpl;
import org.apache.james.mailetcontainer.impl.MatcherMailetPair;
import org.apache.james.mailetcontainer.impl.jmx.JMXStateMailetProcessorListener;
import org.apache.james.mailetcontainer.impl.matchers.CompositeMatcher;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.MailetContext;
import org.apache.mailet.Matcher;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.GenericMailet;
import org.apache.mailet.base.MatcherInverter;
import org.slf4j.Logger;

public abstract class AbstractStateMailetProcessor
implements MailProcessor,
Configurable,
LogEnabled {
    private MailetContext mailetContext;
    private MatcherLoader matcherLoader;
    private MailProcessor rootMailProcessor;
    private final List<MailetProcessorListener> listeners = Collections.synchronizedList(new ArrayList());
    private JMXStateMailetProcessorListener jmxListener;
    private boolean enableJmx = true;
    private Logger logger;
    private HierarchicalConfiguration config;
    private MailetLoader mailetLoader;
    private final List<MatcherMailetPair> pairs = new ArrayList<MatcherMailetPair>();
    private String state;

    public void setMatcherLoader(MatcherLoader matcherLoader) {
        this.matcherLoader = matcherLoader;
    }

    public void setRootMailProcessor(MailProcessor rootMailProcessor) {
        this.rootMailProcessor = rootMailProcessor;
    }

    @Inject
    public void setMailetContext(MailetContext mailetContext) {
        this.mailetContext = mailetContext;
    }

    @Inject
    public void setMailetLoader(MailetLoader mailetLoader) {
        this.mailetLoader = mailetLoader;
    }

    public void setLog(Logger log) {
        this.logger = log;
    }

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        this.state = config.getString("[@state]", null);
        if (this.state == null) {
            throw new ConfigurationException("Processor state attribute must be configured");
        }
        if (this.state.equals("ghost")) {
            throw new ConfigurationException("Processor state of ghost is reserved for internal use, choose a different one");
        }
        this.enableJmx = config.getBoolean("[@enableJmx]", true);
        this.config = config;
    }

    @PostConstruct
    public void init() throws Exception {
        this.parseConfiguration();
        this.setupRouting(this.pairs);
        if (this.enableJmx) {
            this.jmxListener = new JMXStateMailetProcessorListener(this.state, this);
            this.addListener(this.jmxListener);
        }
    }

    @PreDestroy
    public void destroy() {
        this.listeners.clear();
        if (this.enableJmx && this.jmxListener != null) {
            this.jmxListener.dispose();
        }
        for (MatcherMailetPair pair : this.pairs) {
            Mailet mailet = pair.getMailet();
            Matcher matcher = pair.getMatcher();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Shutdown matcher " + matcher.getMatcherInfo());
            }
            matcher.destroy();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Shutdown mailet " + mailet.getMailetInfo());
            }
            mailet.destroy();
        }
    }

    protected void toProcessor(Mail mail) throws MessagingException {
        this.rootMailProcessor.service(mail);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected String getState() {
        return this.state;
    }

    public List<Mailet> getMailets() {
        ArrayList<Mailet> mailets = new ArrayList<Mailet>();
        for (MatcherMailetPair pair : this.pairs) {
            mailets.add(pair.getMailet());
        }
        return Collections.unmodifiableList(mailets);
    }

    public List<Matcher> getMatchers() {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (MatcherMailetPair pair : this.pairs) {
            matchers.add(pair.getMatcher());
        }
        return Collections.unmodifiableList(matchers);
    }

    public void addListener(MailetProcessorListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MailetProcessorListener listener) {
        this.listeners.remove(listener);
    }

    public List<MailetProcessorListener> getListeners() {
        return this.listeners;
    }

    private MailetConfig createMailetConfig(String mailetName, HierarchicalConfiguration configuration) {
        MailetConfigImpl configImpl = new MailetConfigImpl();
        configImpl.setMailetName(mailetName);
        configImpl.setConfiguration((Configuration)configuration);
        configImpl.setMailetContext(this.mailetContext);
        return configImpl;
    }

    private MatcherConfig createMatcherConfig(String matchName) {
        String condition = null;
        int i = matchName.indexOf(61);
        if (i != -1) {
            condition = matchName.substring(i + 1);
            matchName = matchName.substring(0, i);
        }
        MatcherConfigImpl configImpl = new MatcherConfigImpl();
        configImpl.setMatcherName(matchName);
        configImpl.setCondition(condition);
        configImpl.setMailetContext(this.mailetContext);
        return configImpl;
    }

    private List<Matcher> loadCompositeMatchers(String state, Map<String, Matcher> compMap, List<HierarchicalConfiguration> compMatcherConfs) throws ConfigurationException, MessagingException {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (HierarchicalConfiguration c : compMatcherConfs) {
            String compName = c.getString("[@name]", null);
            String matcherName = c.getString("[@match]", null);
            String invertedMatcherName = c.getString("[@notmatch]", null);
            Matcher matcher = null;
            if (matcherName != null && invertedMatcherName != null) {
                throw new ConfigurationException("Please configure only match or nomatch per mailet");
            }
            if (matcherName != null) {
                matcher = this.matcherLoader.getMatcher(this.createMatcherConfig(matcherName));
                if (matcher instanceof CompositeMatcher) {
                    CompositeMatcher compMatcher = (CompositeMatcher)matcher;
                    List<Matcher> childMatcher = this.loadCompositeMatchers(state, compMap, c.configurationsAt("matcher"));
                    for (Matcher aChildMatcher : childMatcher) {
                        compMatcher.add(aChildMatcher);
                    }
                }
            } else if (invertedMatcherName != null) {
                Matcher m = this.matcherLoader.getMatcher(this.createMatcherConfig(invertedMatcherName));
                if (m instanceof CompositeMatcher) {
                    CompositeMatcher compMatcher = (CompositeMatcher)m;
                    List<Matcher> childMatcher = this.loadCompositeMatchers(state, compMap, c.configurationsAt("matcher"));
                    for (Matcher aChildMatcher : childMatcher) {
                        compMatcher.add(aChildMatcher);
                    }
                }
                matcher = new MatcherInverter(m);
            }
            if (matcher == null) {
                throw new ConfigurationException("Unable to load matcher instance");
            }
            matchers.add(matcher);
            if (compName == null) continue;
            if (compMap.containsKey(compName)) {
                throw new ConfigurationException("CompositeMatcher with name " + compName + " is already defined in processor " + state);
            }
            compMap.put(compName, matcher);
        }
        return matchers;
    }

    private void parseConfiguration() throws MessagingException, ConfigurationException {
        HashMap<String, Matcher> compositeMatchers = new HashMap<String, Matcher>();
        this.loadCompositeMatchers(this.getState(), compositeMatchers, this.config.configurationsAt("matcher"));
        List mailetConfs = this.config.configurationsAt("mailet");
        for (HierarchicalConfiguration c : mailetConfs) {
            Mailet mailet;
            String infoBuffer;
            Matcher matcher;
            String mailetClassName = c.getString("[@class]");
            String matcherName = c.getString("[@match]", null);
            String invertedMatcherName = c.getString("[@notmatch]", null);
            try {
                if (matcherName != null && invertedMatcherName != null) {
                    throw new ConfigurationException("Please configure only match or nomatch per mailet");
                }
                if (matcherName != null) {
                    matcher = (Matcher)compositeMatchers.get(matcherName);
                    if (matcher == null) {
                        matcher = this.matcherLoader.getMatcher(this.createMatcherConfig(matcherName));
                    }
                } else if (invertedMatcherName != null) {
                    matcher = (Matcher)compositeMatchers.get(matcherName);
                    if (matcher == null) {
                        matcher = this.matcherLoader.getMatcher(this.createMatcherConfig(invertedMatcherName));
                    }
                    matcher = new MatcherInverter(matcher);
                } else {
                    matcher = this.matcherLoader.getMatcher(this.createMatcherConfig("All"));
                }
                if (this.logger.isInfoEnabled()) {
                    infoBuffer = "Matcher " + matcherName + " instantiated.";
                    this.logger.info(infoBuffer.toString());
                }
            }
            catch (MessagingException ex) {
                if (this.logger.isErrorEnabled()) {
                    String errorBuffer = "Unable to init matcher " + matcherName + ": " + ex.toString();
                    this.logger.error(errorBuffer.toString(), (Throwable)ex);
                    if (ex.getNextException() != null) {
                        this.logger.error("Caused by nested exception: ", (Throwable)ex.getNextException());
                    }
                }
                throw new ConfigurationException("Unable to init matcher " + matcherName, (Throwable)ex);
            }
            try {
                mailet = this.mailetLoader.getMailet(this.createMailetConfig(mailetClassName, c));
                if (this.logger.isInfoEnabled()) {
                    infoBuffer = "Mailet " + mailetClassName + " instantiated.";
                    this.logger.info(infoBuffer.toString());
                }
            }
            catch (MessagingException ex) {
                if (this.logger.isErrorEnabled()) {
                    String errorBuffer = "Unable to init mailet " + mailetClassName + ": " + ex.toString();
                    this.logger.error(errorBuffer.toString(), (Throwable)ex);
                    if (ex.getNextException() != null) {
                        this.logger.error("Caused by nested exception: ", (Throwable)ex.getNextException());
                    }
                }
                throw new ConfigurationException("Unable to init mailet " + mailetClassName, (Throwable)ex);
            }
            if (matcher != null && mailet != null) {
                this.pairs.add(new MatcherMailetPair(matcher, mailet));
                continue;
            }
            throw new ConfigurationException("Unable to load Mailet or Matcher");
        }
    }

    protected abstract void setupRouting(List<MatcherMailetPair> var1) throws MessagingException;

    public static interface MailetProcessorListener {
        public void afterMailet(Mailet var1, String var2, String var3, long var4, MessagingException var6);

        public void afterMatcher(Matcher var1, String var2, Collection<MailAddress> var3, Collection<MailAddress> var4, long var5, MessagingException var7);
    }

    public final class TerminatingMailet
    extends GenericMailet {
        private static final String TERMINATING_MAILET_NAME = "Terminating%Mailet%Name";

        public void service(Mail mail) {
            if (!"error".equals(mail.getState())) {
                String warnBuffer = "Message " + mail.getName() + " reached the end of this processor, and is automatically deleted.  This may indicate a configuration error.";
                AbstractStateMailetProcessor.this.logger.warn(warnBuffer.toString());
            }
            mail.setState("ghost");
        }

        public String getMailetInfo() {
            return this.getMailetName();
        }

        public String getMailetName() {
            return TERMINATING_MAILET_NAME;
        }
    }
}

