/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl.camel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.mail.MessagingException;
import org.apache.camel.Body;
import org.apache.camel.Handler;
import org.apache.camel.InOnly;
import org.apache.camel.Property;
import org.apache.james.core.MailImpl;
import org.apache.james.mailetcontainer.impl.ProcessorUtil;
import org.apache.james.mailetcontainer.impl.camel.CamelMailetProcessor;
import org.apache.james.mailetcontainer.lib.AbstractStateMailetProcessor;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.Matcher;
import org.slf4j.Logger;

@InOnly
public class MatcherSplitter {
    public static final String MATCHER_MATCHED_ATTRIBUTE = "matched";
    public static final String MATCHER_PROPERTY = "matcher";
    public static final String ON_MATCH_EXCEPTION_PROPERTY = "onMatchException";
    public static final String LOGGER_PROPERTY = "logger";
    public static final String MAILETCONTAINER_PROPERTY = "container";
    public static final String METRIC_FACTORY = "metricFactory";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Handler
    public List<Mail> split(@Property(value="matcher") Matcher matcher, @Property(value="onMatchException") String onMatchException, @Property(value="logger") Logger logger, @Property(value="container") CamelMailetProcessor container, @Property(value="metricFactory") MetricFactory metricFactory, @Body Mail mail) throws MessagingException {
        Collection<Object> matchedRcpts = null;
        ArrayList<MailAddress> origRcpts = new ArrayList<MailAddress>(mail.getRecipients());
        long start = System.currentTimeMillis();
        MessagingException ex = null;
        TimeMetric timeMetric = metricFactory.timer(matcher.getClass().getSimpleName());
        try {
            ArrayList<Mail> mails = new ArrayList<Mail>();
            boolean fullMatch = false;
            try {
                matchedRcpts = matcher.match(mail);
                if (matchedRcpts == null) {
                    matchedRcpts = new ArrayList<MailAddress>(0);
                } else if (matchedRcpts != mail.getRecipients()) {
                    ProcessorUtil.verifyMailAddresses(matchedRcpts);
                }
            }
            catch (MessagingException me) {
                ex = me;
                onMatchException = onMatchException == null ? "error" : onMatchException.trim().toLowerCase(Locale.US);
                if (onMatchException.compareTo("nomatch") == 0) {
                    matchedRcpts = new ArrayList(0);
                }
                if (onMatchException.compareTo("matchall") == 0) {
                    matchedRcpts = mail.getRecipients();
                }
                ProcessorUtil.handleException(me, mail, matcher.getMatcherConfig().getMatcherName(), onMatchException, logger);
            }
            if (matchedRcpts != null && !matchedRcpts.isEmpty()) {
                ArrayList rcpts = new ArrayList(mail.getRecipients());
                for (MailAddress mailAddress : matchedRcpts) {
                    rcpts.remove(mailAddress);
                }
                if (rcpts.isEmpty()) {
                    fullMatch = true;
                } else {
                    mail.setRecipients(rcpts);
                    MailImpl newMail = new MailImpl(mail);
                    newMail.setRecipients(matchedRcpts);
                    newMail.setAttribute(MATCHER_MATCHED_ATTRIBUTE, (Serializable)Boolean.valueOf(true));
                    mails.add((Mail)newMail);
                }
            }
            if (fullMatch) {
                mail.setAttribute(MATCHER_MATCHED_ATTRIBUTE, (Serializable)Boolean.valueOf(true));
            }
            mails.add(mail);
            ArrayList<Mail> arrayList = mails;
            return arrayList;
        }
        finally {
            timeMetric.stopAndPublish();
            long complete = System.currentTimeMillis() - start;
            List<AbstractStateMailetProcessor.MailetProcessorListener> listeners = container.getListeners();
            for (AbstractStateMailetProcessor.MailetProcessorListener listener : listeners) {
                if (matchedRcpts == null || matchedRcpts.isEmpty()) {
                    listener.afterMatcher(matcher, mail.getName(), origRcpts, null, complete, ex);
                    continue;
                }
                listener.afterMatcher(matcher, mail.getName(), origRcpts, matchedRcpts, complete, ex);
            }
        }
    }
}

