/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl.camel;

import java.util.List;
import java.util.Locale;
import javax.mail.MessagingException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.james.mailetcontainer.impl.MailetConfigImpl;
import org.apache.james.mailetcontainer.impl.ProcessorUtil;
import org.apache.james.mailetcontainer.impl.camel.CamelMailetProcessor;
import org.apache.james.mailetcontainer.lib.AbstractStateMailetProcessor;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.MailetPipelineLogging;
import org.slf4j.Logger;

public class CamelProcessor
implements Processor {
    private final MetricFactory metricFactory;
    private final Mailet mailet;
    private final Logger logger;
    private final CamelMailetProcessor processor;

    public CamelProcessor(MetricFactory metricFactory, Mailet mailet, Logger logger, CamelMailetProcessor processor) {
        this.metricFactory = metricFactory;
        this.mailet = mailet;
        this.logger = logger;
        this.processor = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        Mail mail = (Mail)exchange.getIn().getBody(Mail.class);
        long start = System.currentTimeMillis();
        TimeMetric timeMetric = this.metricFactory.timer(this.mailet.getClass().getSimpleName());
        MessagingException ex = null;
        try {
            MailetPipelineLogging.logBeginOfMailetProcess((Mailet)this.mailet, (Mail)mail);
            this.mailet.service(mail);
        }
        catch (MessagingException me) {
            ex = me;
            String onMailetException = null;
            MailetConfig mailetConfig = this.mailet.getMailetConfig();
            if (mailetConfig instanceof MailetConfigImpl) {
                onMailetException = ((MailetConfigImpl)mailetConfig).getInitAttribute("onMailetException");
            }
            if ((onMailetException = onMailetException == null ? "error" : onMailetException.trim().toLowerCase(Locale.US)).compareTo("ignore") == 0) {
                ProcessorUtil.verifyMailAddresses(mail.getRecipients());
            }
            ProcessorUtil.handleException(me, mail, this.mailet.getMailetConfig().getMailetName(), onMailetException, this.logger);
        }
        finally {
            timeMetric.stopAndPublish();
            MailetPipelineLogging.logEndOfMailetProcess((Mailet)this.mailet, (Mail)mail);
            List<AbstractStateMailetProcessor.MailetProcessorListener> listeners = this.processor.getListeners();
            long complete = System.currentTimeMillis() - start;
            if (mail.getRecipients().isEmpty()) {
                mail.setState("ghost");
            }
            for (AbstractStateMailetProcessor.MailetProcessorListener listener : listeners) {
                listener.afterMailet(this.mailet, mail.getName(), mail.getState(), complete, ex);
            }
        }
    }
}

