/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl.camel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.mail.MessagingException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.james.mailetcontainer.impl.MailetConfigImpl;
import org.apache.james.mailetcontainer.impl.MatcherMailetPair;
import org.apache.james.mailetcontainer.impl.camel.CamelProcessor;
import org.apache.james.mailetcontainer.impl.camel.DisposeProcessor;
import org.apache.james.mailetcontainer.impl.camel.MailStateEquals;
import org.apache.james.mailetcontainer.impl.camel.MailStateNotEquals;
import org.apache.james.mailetcontainer.impl.camel.MatcherMatch;
import org.apache.james.mailetcontainer.impl.camel.MatcherSplitter;
import org.apache.james.mailetcontainer.lib.AbstractStateMailetProcessor;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.Matcher;
import org.slf4j.Logger;

public class CamelMailetProcessor
extends AbstractStateMailetProcessor
implements CamelContextAware {
    private CamelContext context;
    private ProducerTemplate producerTemplate;
    private final UseLatestAggregationStrategy aggr = new UseLatestAggregationStrategy();
    private final MetricFactory metricFactory;
    private List<MatcherMailetPair> pairs;

    public CamelMailetProcessor(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    public void service(Mail mail) throws MessagingException {
        try {
            this.producerTemplate.sendBody(this.getEndpoint(), (Object)mail);
        }
        catch (CamelExecutionException ex) {
            throw new MessagingException("Unable to process mail " + mail.getName(), (Exception)((Object)ex));
        }
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public void setCamelContext(CamelContext context) {
        this.context = context;
    }

    public List<MatcherMailetPair> getPairs() {
        return ImmutableList.copyOf(this.pairs);
    }

    protected String getEndpoint() {
        return "direct:processor." + this.getState();
    }

    @Override
    @PostConstruct
    public void init() throws Exception {
        this.producerTemplate = this.context.createProducerTemplate();
        if (this.context.getStatus().isStopped()) {
            this.context.start();
        }
        super.init();
    }

    @Override
    protected void setupRouting(List<MatcherMailetPair> pairs) throws MessagingException {
        try {
            this.pairs = pairs;
            this.context.addRoutes((RoutesBuilder)new MailetContainerRouteBuilder(pairs));
        }
        catch (Exception e) {
            throw new MessagingException("Unable to setup routing for MailetMatcherPairs", e);
        }
    }

    private final class MailetContainerRouteBuilder
    extends RouteBuilder {
        private final List<MatcherMailetPair> pairs;

        public MailetContainerRouteBuilder(List<MatcherMailetPair> pairs) {
            this.pairs = pairs;
        }

        public void configure() throws Exception {
            DisposeProcessor disposeProcessor = new DisposeProcessor();
            RemovePropertiesProcessor removePropsProcessor = new RemovePropertiesProcessor();
            CompleteProcessor completeProcessor = new CompleteProcessor();
            StateChangedProcessor stateChangedProcessor = new StateChangedProcessor();
            String state = CamelMailetProcessor.this.getState();
            Logger logger = CamelMailetProcessor.this.getLogger();
            RouteDefinition processorDef = (RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(CamelMailetProcessor.this.getEndpoint()).routeId(state).setExchangePattern(ExchangePattern.InOnly)).setProperty("logger", (Expression)this.constant(CamelMailetProcessor.this.getLogger()))).setProperty("metricFactory", (Expression)this.constant(CamelMailetProcessor.this.metricFactory));
            for (MatcherMailetPair pair : this.pairs) {
                Matcher matcher = pair.getMatcher();
                Mailet mailet = pair.getMailet();
                String onMatchException = null;
                MailetConfig mailetConfig = mailet.getMailetConfig();
                if (mailetConfig instanceof MailetConfigImpl) {
                    onMatchException = ((MailetConfigImpl)mailetConfig).getInitAttribute("onMatchException");
                }
                CamelProcessor mailetProccessor = new CamelProcessor(CamelMailetProcessor.this.metricFactory, mailet, logger, CamelMailetProcessor.this);
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((SplitDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)processorDef.setProperty("matcher", (Expression)this.constant(matcher))).setProperty("onMatchException", (Expression)this.constant(onMatchException))).setProperty("container", (Expression)this.constant(CamelMailetProcessor.this))).split().method(MatcherSplitter.class)).aggregationStrategy((AggregationStrategy)CamelMailetProcessor.this.aggr).choice().when((Predicate)new MatcherMatch()).process((Processor)mailetProccessor)).end().choice().when((Predicate)new MailStateEquals("ghost")).process((Processor)disposeProcessor)).stop()).otherwise().process((Processor)removePropsProcessor)).end().choice().when((Predicate)new MailStateNotEquals(state)).process((Processor)stateChangedProcessor)).process((Processor)completeProcessor)).stop()).end();
            }
            CamelProcessor terminatingMailetProcessor = new CamelProcessor(CamelMailetProcessor.this.metricFactory, (Mailet)new AbstractStateMailetProcessor.TerminatingMailet(CamelMailetProcessor.this), CamelMailetProcessor.this.getLogger(), CamelMailetProcessor.this);
            ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)processorDef.choice().when((Predicate)new MailStateEquals(state)).process((Processor)terminatingMailetProcessor)).stop()).when((Predicate)new MailStateEquals("ghost")).process((Processor)disposeProcessor)).stop()).otherwise().process((Processor)completeProcessor)).stop();
        }

        private final class StateChangedProcessor
        implements Processor {
            private StateChangedProcessor() {
            }

            public void process(Exchange arg0) throws Exception {
                Mail mail = (Mail)arg0.getIn().getBody(Mail.class);
                CamelMailetProcessor.this.toProcessor(mail);
            }
        }

        private final class CompleteProcessor
        implements Processor {
            private CompleteProcessor() {
            }

            public void process(Exchange ex) throws Exception {
                CamelMailetProcessor.this.getLogger().debug("End of mailetprocessor for state " + CamelMailetProcessor.this.getState() + " reached");
                ex.setProperty("CamelRouteStop", (Object)true);
            }
        }

        private final class RemovePropertiesProcessor
        implements Processor {
            private RemovePropertiesProcessor() {
            }

            public void process(Exchange exchange) throws Exception {
                exchange.removeProperty("onMatchException");
                exchange.removeProperty("matcher");
            }
        }
    }
}

