/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl.camel;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.mailetcontainer.api.MailProcessor;
import org.apache.james.mailetcontainer.api.MailetLoader;
import org.apache.james.mailetcontainer.api.MatcherLoader;
import org.apache.james.mailetcontainer.impl.camel.CamelMailetProcessor;
import org.apache.james.mailetcontainer.lib.AbstractStateCompositeProcessor;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.mailet.MailetContext;

public class CamelCompositeProcessor
extends AbstractStateCompositeProcessor
implements CamelContextAware {
    private final MetricFactory metricFactory;
    private CamelContext camelContext;
    private MailetContext mailetContext;
    private MatcherLoader matcherLoader;
    private MailetLoader mailetLoader;

    @Inject
    public CamelCompositeProcessor(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    @Inject
    public void setMatcherLoader(MatcherLoader matcherLoader) {
        this.matcherLoader = matcherLoader;
    }

    @Inject
    public void setMailetLoader(MailetLoader mailetLoader) {
        this.mailetLoader = mailetLoader;
    }

    @Inject
    public void setMailetContext(MailetContext mailetContext) {
        this.mailetContext = mailetContext;
    }

    @Override
    @PostConstruct
    public void init() throws Exception {
        super.init();
        if (this.getCamelContext().getStatus().isStopped()) {
            this.getCamelContext().start();
        }
    }

    @PreDestroy
    public void destroy() throws Exception {
        if (this.getCamelContext().getStatus().isStarted()) {
            this.getCamelContext().stop();
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    protected MailProcessor createMailProcessor(String name, HierarchicalConfiguration config) throws Exception {
        CamelMailetProcessor processor = new CamelMailetProcessor(this.metricFactory);
        try {
            processor.setLog(this.logger);
            processor.setCamelContext(this.camelContext);
            processor.setMailetContext(this.mailetContext);
            processor.setMailetLoader(this.mailetLoader);
            processor.setMatcherLoader(this.matcherLoader);
            processor.configure(config);
            processor.setRootMailProcessor(this);
            processor.init();
            return processor;
        }
        catch (Exception e) {
            processor.destroy();
            throw e;
        }
    }
}

