/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.thread.impl;

import org.apache.excalibur.thread.Executable;
import org.apache.excalibur.thread.ThreadControl;
import org.apache.excalibur.thread.ThreadPool;
import org.apache.excalibur.thread.impl.ExecutableRunnable;
import org.apache.excalibur.thread.impl.WorkerThread;

public abstract class AbstractThreadPool
implements ThreadPool {
    private final ThreadGroup m_threadGroup;
    private final String m_name;
    private int m_level;

    public AbstractThreadPool(String name, ThreadGroup threadGroup) throws Exception {
        if (null == name) {
            throw new NullPointerException("name");
        }
        if (null == threadGroup) {
            throw new NullPointerException("threadGroup");
        }
        this.m_name = name;
        this.m_threadGroup = threadGroup;
    }

    protected void destroyWorker(WorkerThread thread) {
        thread.dispose();
    }

    protected WorkerThread createWorker() {
        String name = this.m_name + " Worker #" + this.m_level++;
        WorkerThread worker = this.newWorkerThread(name);
        worker.setDaemon(true);
        worker.start();
        return worker;
    }

    protected WorkerThread newWorkerThread(String name) {
        return new WorkerThread(this, this.m_threadGroup, name);
    }

    public ThreadControl execute(Runnable work) {
        return this.execute(new ExecutableRunnable(work));
    }

    public ThreadControl execute(Executable work) {
        WorkerThread worker = this.getWorker();
        return worker.execute(work);
    }

    protected String getName() {
        return this.m_name;
    }

    protected ThreadGroup getThreadGroup() {
        return this.m_threadGroup;
    }

    protected abstract WorkerThread getWorker();

    protected abstract void releaseWorker(WorkerThread var1);
}

