/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.manager;

import java.io.File;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import mx4j.adaptor.rmi.jrmp.JRMPAdaptorMBean;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.util.StandardMBeanProxy;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.phoenix.components.manager.AbstractJMXManager;
import org.apache.avalon.phoenix.components.manager.MX4JLoggerAdapter;

public class MX4JSystemManager
extends AbstractJMXManager
implements Contextualizable,
Configurable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$components$manager$MX4JSystemManager == null ? (class$org$apache$avalon$phoenix$components$manager$MX4JSystemManager = MX4JSystemManager.class$("org.apache.avalon.phoenix.components.manager.MX4JSystemManager")) : class$org$apache$avalon$phoenix$components$manager$MX4JSystemManager));
    private static final String DEFAULT_NAMING_FACTORY = "com.sun.jndi.rmi.profile.RegistryContextFactory";
    private static final String DEFAULT_HTTPADAPTER_HOST = "localhost";
    private static final int DEFAULT_HTTPADAPTER_PORT = Integer.getInteger("phoenix.adapter.http", 8082);
    private static final int DEFAULT_RMIREGISTRY_PORT = Integer.getInteger("phoenix.rmiregistry.port", 1099);
    private String m_host;
    private int m_port;
    private boolean m_rmi;
    private int m_rmi_registry_port;
    private File m_homeDir;
    private String m_stylesheetDir;
    private String m_namingFactory;
    private String m_password;
    private String m_username;
    private boolean m_http;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$components$manager$MX4JSystemManager;
    static /* synthetic */ Class class$mx4j$adaptor$rmi$jrmp$JRMPAdaptorMBean;

    public void contextualize(Context context) throws ContextException {
        this.m_homeDir = (File)context.get((Object)"phoenix.home");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_host = configuration.getChild("manager-adaptor-host").getValue(DEFAULT_HTTPADAPTER_HOST);
        this.m_port = configuration.getChild("manager-adaptor-port").getValueAsInteger(DEFAULT_HTTPADAPTER_PORT);
        this.m_port = configuration.getChild("port").getValueAsInteger(this.m_port);
        this.getLogger().debug("MX4J HTTP listener port: " + this.m_port);
        this.m_rmi = configuration.getChild("enable-rmi-adaptor").getValueAsBoolean(false);
        this.m_rmi_registry_port = configuration.getChild("rmi-registry-port").getValueAsInteger(DEFAULT_RMIREGISTRY_PORT);
        this.m_http = configuration.getChild("enable-http-adaptor").getValueAsBoolean(false);
        this.m_namingFactory = configuration.getChild("rmi-naming-factory").getValue(DEFAULT_NAMING_FACTORY);
        String stylesheets = configuration.getChild("stylesheets-dir").getValue(null);
        if (null != stylesheets) {
            this.m_stylesheetDir = new File(this.m_homeDir, stylesheets).getAbsolutePath();
        }
        Configuration userConfig = configuration.getChild("user");
        this.m_username = userConfig.getChild("name").getValue(null);
        this.m_password = userConfig.getChild("password").getValue(null);
    }

    public void initialize() throws Exception {
        super.initialize();
        MBeanServer mBeanServer = this.getMBeanServer();
        if (this.m_http) {
            this.startHttpAdaptor(mBeanServer);
        }
        if (this.m_rmi) {
            this.startRMIAdaptor(mBeanServer);
        }
    }

    public void dispose() {
        MBeanServer mBeanServer = this.getMBeanServer();
        if (this.m_http) {
            this.stopHttpAdaptor(mBeanServer);
        }
        if (this.m_rmi) {
            this.stopRMIAdaptor(mBeanServer);
        }
        super.dispose();
    }

    private void startHttpAdaptor(MBeanServer mBeanServer) throws Exception {
        ObjectName adaptorName = new ObjectName("Http:name=HttpAdaptor");
        mBeanServer.createMBean("mx4j.adaptor.http.HttpAdaptor", adaptorName, null);
        mBeanServer.setAttribute(adaptorName, new Attribute("Host", this.m_host));
        mBeanServer.setAttribute(adaptorName, new Attribute("Port", new Integer(this.m_port)));
        if (null != this.m_username) {
            this.configureAuthentication(mBeanServer, adaptorName);
        }
        this.configureProcessor(mBeanServer, adaptorName);
        mBeanServer.invoke(adaptorName, "start", null, null);
    }

    private void configureProcessor(MBeanServer mBeanServer, ObjectName adaptorName) throws Exception {
        ObjectName processorName = new ObjectName("Http:name=XSLTProcessor");
        mBeanServer.createMBean("mx4j.adaptor.http.XSLTProcessor", processorName, null);
        mBeanServer.setAttribute(adaptorName, new Attribute("ProcessorName", processorName));
        if (null != this.m_stylesheetDir) {
            Attribute stylesheetDir = new Attribute("File", this.m_stylesheetDir);
            mBeanServer.setAttribute(processorName, stylesheetDir);
        }
        Attribute useCache = new Attribute("UseCache", Boolean.FALSE);
        mBeanServer.setAttribute(processorName, useCache);
    }

    private void configureAuthentication(MBeanServer mBeanServer, ObjectName adaptorName) throws InstanceNotFoundException, MBeanException, ReflectionException, AttributeNotFoundException, InvalidAttributeValueException {
        mBeanServer.invoke(adaptorName, "addAuthorization", new Object[]{this.m_username, this.m_password}, new String[]{"java.lang.String", "java.lang.String"});
        mBeanServer.setAttribute(adaptorName, new Attribute("AuthenticationMethod", "basic"));
    }

    private void stopHttpAdaptor(MBeanServer server) {
        this.stopJMXMBean(server, "Http:name=HttpAdaptor");
    }

    private void startRMIAdaptor(MBeanServer server) throws Exception {
        ObjectName naming = new ObjectName("Naming:type=rmiregistry");
        server.createMBean("mx4j.tools.naming.NamingService", naming, null, new Object[]{new Integer(this.m_rmi_registry_port)}, new String[]{"int"});
        server.invoke(naming, "start", null, null);
        ObjectName adaptor = new ObjectName("Adaptor:protocol=JRMP");
        server.createMBean("mx4j.adaptor.rmi.jrmp.JRMPAdaptor", adaptor, null);
        JRMPAdaptorMBean mbean = (JRMPAdaptorMBean)StandardMBeanProxy.create((Class)(class$mx4j$adaptor$rmi$jrmp$JRMPAdaptorMBean == null ? (class$mx4j$adaptor$rmi$jrmp$JRMPAdaptorMBean = MX4JSystemManager.class$("mx4j.adaptor.rmi.jrmp.JRMPAdaptorMBean")) : class$mx4j$adaptor$rmi$jrmp$JRMPAdaptorMBean), (MBeanServer)server, (ObjectName)adaptor);
        mbean.setJNDIName("jrmp");
        mbean.putJNDIProperty((Object)"java.naming.factory.initial", (Object)this.m_namingFactory);
        mbean.putJNDIProperty((Object)"java.naming.provider.url", (Object)("rmi://localhost:" + this.m_rmi_registry_port));
        mbean.start();
    }

    private void stopRMIAdaptor(MBeanServer server) {
        this.stopJMXMBean(server, "Adaptor:protocol=JRMP");
        this.stopJMXMBean(server, "Naming:type=rmiregistry");
    }

    protected MBeanServer createMBeanServer() throws Exception {
        MX4JLoggerAdapter.setLogger(this.getLogger());
        Log.redirectTo((Logger)new MX4JLoggerAdapter());
        return MBeanServerFactory.createMBeanServer("Phoenix");
    }

    private void stopJMXMBean(MBeanServer mBeanServer, String name) {
        try {
            ObjectName objectName = new ObjectName(name);
            mBeanServer.invoke(objectName, "stop", null, null);
        }
        catch (Exception e) {
            String message = REZ.getString("jmxmanager.error.jmxmbean.dispose", (Object)name);
            this.getLogger().error(message, (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

