/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.manager;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import mx4j.log.Log;
import mx4j.log.Logger;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.phoenix.components.manager.AbstractJMXManager;
import org.apache.avalon.phoenix.components.manager.MBeanScripter;
import org.apache.avalon.phoenix.components.manager.MX4JLoggerAdapter;

public class ExtendedMX4JSystemManager
extends AbstractJMXManager
implements Configurable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$components$manager$ExtendedMX4JSystemManager == null ? (class$org$apache$avalon$phoenix$components$manager$ExtendedMX4JSystemManager = ExtendedMX4JSystemManager.class$("org.apache.avalon.phoenix.components.manager.ExtendedMX4JSystemManager")) : class$org$apache$avalon$phoenix$components$manager$ExtendedMX4JSystemManager));
    private static final String DEFAULT_NAMING_FACTORY = "com.sun.jndi.rmi.profile.RegistryContextFactory";
    private Configuration m_configuration;
    private Map m_mBeanScripters;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$components$manager$ExtendedMX4JSystemManager;

    public void configure(Configuration configuration) throws ConfigurationException {
        String namingFactory = configuration.getChild("rmi-naming-factory").getValue(null);
        if (null != namingFactory) {
            this.getLogger().warn("Deprecated.");
            System.setProperty("java.naming.factory.initial", namingFactory);
        } else if (null == System.getProperty("java.naming.factory.initial")) {
            System.setProperty("java.naming.factory.initial", DEFAULT_NAMING_FACTORY);
        }
        this.m_configuration = configuration;
    }

    public void initialize() throws Exception {
        super.initialize();
        this.m_mBeanScripters = new HashMap();
        Configuration[] scripters = this.m_configuration.getChildren("mbean");
        for (int i = 0; i < scripters.length; ++i) {
            this.createMBeanScripter(scripters[i]);
        }
    }

    public void dispose() {
        Iterator scripterNames = this.m_mBeanScripters.keySet().iterator();
        while (scripterNames.hasNext()) {
            this.destroyMBeanScripter((String)scripterNames.next());
        }
        this.m_mBeanScripters.clear();
        this.m_mBeanScripters = null;
        super.dispose();
    }

    private void createMBeanScripter(Configuration scripterConf) throws Exception {
        MBeanScripter scripter = new MBeanScripter(this.getMBeanServer(), scripterConf);
        try {
            scripter.startup();
            this.m_mBeanScripters.put(scripter.getName(), scripter);
        }
        catch (Exception e) {
            String message = REZ.getString("jmxmanager.error.jmxmbean.initialize", (Object)scripter.getName());
            this.getLogger().error(message, (Throwable)e);
            throw e;
        }
    }

    private void destroyMBeanScripter(String name) {
        MBeanScripter scripter = (MBeanScripter)this.m_mBeanScripters.get(name);
        try {
            scripter.shutdown();
        }
        catch (Exception e) {
            String message = REZ.getString("jmxmanager.error.jmxmbean.dispose", (Object)scripter.getName());
            this.getLogger().error(message, (Throwable)e);
        }
    }

    protected MBeanServer createMBeanServer() throws Exception {
        MX4JLoggerAdapter.setLogger(this.getLogger());
        Log.redirectTo((Logger)new MX4JLoggerAdapter());
        return MBeanServerFactory.createMBeanServer("Phoenix");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

