/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.installer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.excalibur.io.FileUtil;
import org.apache.avalon.excalibur.io.IOUtil;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.phoenix.interfaces.InstallationException;
import org.apache.avalon.phoenix.interfaces.Installer;

public class DefaultInstaller
extends AbstractLogEnabled
implements Installer,
Parameterizable,
Initializable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$components$installer$DefaultInstaller == null ? (class$org$apache$avalon$phoenix$components$installer$DefaultInstaller = DefaultInstaller.class$("org.apache.avalon.phoenix.components.installer.DefaultInstaller")) : class$org$apache$avalon$phoenix$components$installer$DefaultInstaller));
    private static final String META_INF = "META-INF";
    private static final String SAR_INF = "SAR-INF";
    private static final String LIB = "SAR-INF/lib";
    private static final String CLASSES = "SAR-INF/classes/";
    private static final String FS_CONFIG_XML = "SAR-INF" + File.separator + "config.xml";
    private static final String FS_ASSEMBLY_XML = "SAR-INF" + File.separator + "assembly.xml";
    private static final String FS_ENV_XML = "SAR-INF" + File.separator + "environment.xml";
    private static final String FS_CLASSES = "SAR-INF" + File.separator + "classes" + File.separator;
    private File m_baseWorkDirectory;
    private File m_baseDirectory;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$components$installer$DefaultInstaller;

    public void parameterize(Parameters parameters) throws ParameterException {
        String phoenixHome = parameters.getParameter("phoenix.home");
        String defaultWorkDir = phoenixHome + File.separator + "work";
        String defaultAppsDir = phoenixHome + File.separator + "apps";
        String rawWorkDir = parameters.getParameter("phoenix.work.dir", defaultWorkDir);
        String rawAppsDir = parameters.getParameter("phoenix.apps.dir", defaultAppsDir);
        File workDir = new File(rawWorkDir);
        try {
            this.m_baseWorkDirectory = workDir.getCanonicalFile();
        }
        catch (IOException ioe) {
            this.m_baseWorkDirectory = workDir.getAbsoluteFile();
        }
        File appsDir = new File(rawAppsDir);
        try {
            this.m_baseDirectory = appsDir.getCanonicalFile();
        }
        catch (IOException ioe) {
            this.m_baseDirectory = appsDir.getAbsoluteFile();
        }
    }

    public void initialize() throws Exception {
        this.initWorkDirectory();
        try {
            FileUtil.cleanDirectory((File)this.m_baseWorkDirectory);
        }
        catch (IOException ioe) {
            String message = REZ.getString("nodelete-workdir.error", (Object)this.m_baseWorkDirectory, (Object)ioe.getMessage());
            this.getLogger().warn(message, (Throwable)ioe);
        }
    }

    public void uninstall(Map installation) throws InstallationException {
        File work = (File)installation.get("install:work");
        this.deleteWorkDir(work);
    }

    private void deleteWorkDir(File dir) {
        try {
            FileUtil.deleteDirectory((File)dir);
        }
        catch (IOException ioe) {
            try {
                FileUtil.forceDeleteOnExit((File)dir);
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            String message = REZ.getString("nodelete-workdir.error", (Object)dir, (Object)ioe.getMessage());
            this.getLogger().warn(message, (Throwable)ioe);
        }
    }

    public Map install(String name, URL url) throws InstallationException {
        this.lock();
        try {
            String notice = REZ.getString("installing-sar", (Object)url);
            this.getLogger().info(notice);
            File file = this.getFileFor(url);
            if (file.isDirectory()) {
                String message = REZ.getString("install.sar-isa-dir.error", (Object)name, (Object)url);
                throw new InstallationException(message);
            }
            ZipFile zipFile = new ZipFile(file);
            Map map = this.installArchive(name, url, file, zipFile);
            return map;
        }
        catch (IOException ioe) {
            String message = REZ.getString("bad-zip-file", (Object)url);
            throw new InstallationException(message, ioe);
        }
        finally {
            this.unlock();
        }
    }

    private void lock() {
    }

    private void unlock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map installArchive(String name, URL url, File file, ZipFile zipFile) throws InstallationException {
        File directory = new File(this.m_baseDirectory, name).getAbsoluteFile();
        directory.mkdirs();
        File workDir = this.getRelativeWorkDir(name);
        boolean success = false;
        try {
            this.expandZipFile(zipFile, directory, workDir, url);
            String assembly = this.getURLAsString(new File(directory, FS_ASSEMBLY_XML));
            String config = this.getURLAsString(new File(directory, FS_CONFIG_XML));
            String environment = this.getURLAsString(new File(directory, FS_ENV_XML));
            success = true;
            HashMap<String, Object> install = new HashMap<String, Object>();
            install.put("install:source", file);
            install.put("install:home", directory);
            install.put("install:work", workDir);
            install.put("install:config", config);
            install.put("install:assembly", assembly);
            install.put("install:environment", environment);
            HashMap<String, Object> hashMap = install;
            return hashMap;
        }
        finally {
            if (!success) {
                this.deleteWorkDir(workDir);
            }
        }
    }

    private void expandZipFile(ZipFile zipFile, File directory, File workDir, URL url) throws InstallationException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = this.fixName(entry.getName());
            if (name.startsWith(META_INF) || this.handleDirs(entry, name, directory) || this.handleClasses(zipFile, entry, name, workDir) || this.handleJars(zipFile, entry, name, workDir)) continue;
            File destination = new File(directory, name);
            this.handleFile(zipFile, entry, destination, url);
        }
    }

    private void handleFile(ZipFile zipFile, ZipEntry entry, File destination, URL url) throws InstallationException {
        if (!destination.exists()) {
            this.expandFile(zipFile, entry, destination);
        } else {
            String message = REZ.getString("file-in-the-way", (Object)url, (Object)entry.getName(), (Object)destination);
            this.getLogger().warn(message);
        }
    }

    private boolean handleJars(ZipFile zipFile, ZipEntry entry, String name, File workDir) throws InstallationException {
        if (name.startsWith(LIB) && name.endsWith(".jar") && LIB.length() == name.lastIndexOf("/")) {
            File file = new File(workDir, name);
            this.expandFile(zipFile, entry, file);
            return true;
        }
        return false;
    }

    private boolean handleClasses(ZipFile zipFile, ZipEntry entry, String name, File workDir) throws InstallationException {
        if (name.startsWith(CLASSES)) {
            File classDir = new File(workDir, FS_CLASSES);
            if (!classDir.exists()) {
                File file = new File(workDir, name);
                this.expandFile(zipFile, entry, file);
            }
            return true;
        }
        return false;
    }

    private boolean handleDirs(ZipEntry entry, String name, File directory) {
        if (entry.isDirectory()) {
            if (!name.startsWith(SAR_INF)) {
                File newDir = new File(directory, name);
                newDir.mkdirs();
            }
            return true;
        }
        return false;
    }

    private File getRelativeWorkDir(String name) {
        String filename = name + "-" + System.currentTimeMillis();
        return new File(this.m_baseWorkDirectory, filename);
    }

    private String fixName(String name) {
        if (name.startsWith("/")) {
            return name.substring(1);
        }
        return name;
    }

    private File getFileFor(URL url) throws InstallationException {
        if (!url.getProtocol().equals("file")) {
            String message = REZ.getString("install-nonlocal", (Object)url);
            throw new InstallationException(message);
        }
        File file = new File(url.getFile());
        if (!(file = file.getAbsoluteFile()).exists()) {
            String message = REZ.getString("install-nourl", (Object)file);
            throw new InstallationException(message);
        }
        return file;
    }

    private void expandFile(ZipFile zipFile, ZipEntry entry, File file) throws InstallationException {
        InputStream input = null;
        FileOutputStream output = null;
        try {
            file.getParentFile().mkdirs();
            output = new FileOutputStream(file);
            input = zipFile.getInputStream(entry);
            IOUtil.copy((InputStream)input, (OutputStream)output);
        }
        catch (IOException ioe) {
            try {
                String message = REZ.getString("failed-to-expand", (Object)entry.getName(), (Object)file, (Object)ioe.getMessage());
                throw new InstallationException(message, ioe);
            }
            catch (Throwable throwable) {
                IOUtil.shutdownStream(input);
                IOUtil.shutdownStream(output);
                throw throwable;
            }
        }
        IOUtil.shutdownStream((InputStream)input);
        IOUtil.shutdownStream((OutputStream)output);
    }

    private String getURLAsString(File file) {
        try {
            return file.toURL().toExternalForm();
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    private void initWorkDirectory() throws Exception {
        String message;
        if (!this.m_baseWorkDirectory.exists()) {
            message = REZ.getString("install.create-dir.notice", (Object)this.m_baseWorkDirectory);
            this.getLogger().info(message);
            if (!this.m_baseWorkDirectory.mkdirs()) {
                String error = REZ.getString("install.workdir-nocreate.error", (Object)this.m_baseWorkDirectory);
                throw new Exception(error);
            }
        }
        if (!this.m_baseWorkDirectory.isDirectory()) {
            message = REZ.getString("install.workdir-notadir.error", (Object)this.m_baseWorkDirectory);
            throw new Exception(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

