/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.application;

import org.apache.avalon.phoenix.ApplicationEvent;
import org.apache.avalon.phoenix.ApplicationListener;
import org.apache.avalon.phoenix.BlockEvent;
import org.apache.avalon.phoenix.BlockListener;
import org.apache.avalon.phoenix.components.application.BlockEntry;
import org.apache.avalon.phoenix.components.util.ComponentInfoConverter;
import org.apache.avalon.phoenix.containerkit.profile.ComponentProfile;
import org.apache.avalon.phoenix.metadata.SarMetaData;
import org.apache.avalon.phoenix.metainfo.BlockInfo;

final class ListenerSupport {
    private BlockListener[] m_blockListeners = new BlockListener[0];
    private ApplicationListener[] m_listeners = new ApplicationListener[0];

    ListenerSupport() {
    }

    void fireApplicationStartingEvent(SarMetaData metaData) throws Exception {
        ApplicationEvent event = new ApplicationEvent(metaData.getName(), metaData);
        this.applicationStarting(event);
    }

    void fireBlockAddedEvent(BlockEntry entry) {
        this.blockAdded(this.createEvent(entry));
    }

    void fireBlockRemovedEvent(BlockEntry entry) {
        this.blockRemoved(this.createEvent(entry));
    }

    private BlockEvent createEvent(BlockEntry entry) {
        ComponentProfile profile = entry.getProfile();
        BlockInfo blockInfo = ComponentInfoConverter.toBlockInfo(profile.getInfo());
        BlockEvent event = new BlockEvent(profile.getMetaData().getName(), entry.getProxy(), blockInfo);
        return event;
    }

    public synchronized void addApplicationListener(ApplicationListener listener) {
        ApplicationListener[] listeners = new ApplicationListener[1 + this.m_listeners.length];
        System.arraycopy(this.m_listeners, 0, listeners, 0, this.m_listeners.length);
        listeners[this.m_listeners.length] = listener;
        this.m_listeners = listeners;
    }

    public synchronized void removeApplicationListener(ApplicationListener listener) {
        int index;
        for (index = 0; index < this.m_listeners.length && this.m_listeners[index] != listener; ++index) {
        }
        if (this.m_listeners.length != index) {
            ApplicationListener[] listeners = new ApplicationListener[this.m_listeners.length - 1];
            System.arraycopy(this.m_listeners, 0, listeners, 0, index);
            int length = this.m_listeners.length - index - 1;
            System.arraycopy(this.m_listeners, index + 1, listeners, index, length);
        }
    }

    public synchronized void addBlockListener(BlockListener listener) {
        BlockListener[] listeners = new BlockListener[1 + this.m_blockListeners.length];
        System.arraycopy(this.m_blockListeners, 0, listeners, 0, this.m_blockListeners.length);
        listeners[this.m_listeners.length] = listener;
        this.m_blockListeners = listeners;
    }

    public synchronized void removeBlockListener(BlockListener listener) {
        int index;
        for (index = 0; index < this.m_blockListeners.length && this.m_blockListeners[index] != listener; ++index) {
        }
        if (this.m_blockListeners.length != index) {
            BlockListener[] listeners = new BlockListener[this.m_blockListeners.length - 1];
            System.arraycopy(this.m_blockListeners, 0, listeners, 0, index);
            int length = this.m_blockListeners.length - index - 1;
            System.arraycopy(this.m_blockListeners, index + 1, listeners, index, length);
        }
    }

    private synchronized void applicationStarting(ApplicationEvent event) throws Exception {
        for (int i = 0; i < this.m_listeners.length; ++i) {
            this.m_listeners[i].applicationStarting(event);
        }
    }

    public synchronized void applicationStarted() {
        for (int i = 0; i < this.m_listeners.length; ++i) {
            this.m_listeners[i].applicationStarted();
        }
    }

    public synchronized void applicationStopping() {
        for (int i = 0; i < this.m_listeners.length; ++i) {
            this.m_listeners[i].applicationStopping();
        }
    }

    public synchronized void applicationStopped() {
        for (int i = 0; i < this.m_listeners.length; ++i) {
            this.m_listeners[i].applicationStopped();
        }
    }

    public synchronized void applicationFailure(Exception causeOfFailure) {
        for (int i = 0; i < this.m_listeners.length; ++i) {
            this.m_listeners[i].applicationFailure(causeOfFailure);
        }
    }

    private synchronized void blockAdded(BlockEvent event) {
        int i;
        for (i = 0; i < this.m_listeners.length; ++i) {
            this.m_listeners[i].blockAdded(event);
        }
        for (i = 0; i < this.m_blockListeners.length; ++i) {
            this.m_blockListeners[i].blockAdded(event);
        }
    }

    private synchronized void blockRemoved(BlockEvent event) {
        int i;
        for (i = 0; i < this.m_listeners.length; ++i) {
            this.m_listeners[i].blockRemoved(event);
        }
        for (i = 0; i < this.m_blockListeners.length; ++i) {
            this.m_blockListeners[i].blockRemoved(event);
        }
    }
}

