/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.application;

import java.util.ArrayList;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.containerkit.profile.ComponentProfile;
import org.apache.avalon.phoenix.framework.info.ServiceDescriptor;
import org.apache.avalon.phoenix.framework.tools.infobuilder.LegacyUtil;
import org.apache.avalon.phoenix.interfaces.ApplicationContext;

class ExportHelper
extends AbstractLogEnabled {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$components$application$ExportHelper == null ? (class$org$apache$avalon$phoenix$components$application$ExportHelper = ExportHelper.class$("org.apache.avalon.phoenix.components.application.ExportHelper")) : class$org$apache$avalon$phoenix$components$application$ExportHelper));
    static /* synthetic */ Class class$org$apache$avalon$phoenix$components$application$ExportHelper;

    ExportHelper() {
    }

    void exportBlock(ApplicationContext context, ComponentProfile profile, Object block) throws CascadingException {
        ServiceDescriptor[] services = this.getMxServices(profile);
        String name = profile.getMetaData().getName();
        ClassLoader classLoader = block.getClass().getClassLoader();
        Class[] serviceClasses = new Class[services.length];
        for (int i = 0; i < services.length; ++i) {
            ServiceDescriptor service = services[i];
            try {
                serviceClasses[i] = classLoader.loadClass(service.getType());
                continue;
            }
            catch (Exception e) {
                String reason = e.toString();
                String message = REZ.getString("bad-mx-service.error", (Object)name, (Object)service.getType(), (Object)reason);
                this.getLogger().error(message);
                throw new CascadingException(message, (Throwable)e);
            }
        }
        try {
            context.exportObject(name, serviceClasses, block);
        }
        catch (Exception e) {
            String message = REZ.getString("export.error", (Object)name, (Object)e);
            this.getLogger().error(message);
            throw new CascadingException(message, (Throwable)e);
        }
    }

    private ServiceDescriptor[] getMxServices(ComponentProfile profile) {
        ArrayList<ServiceDescriptor> mxServices = new ArrayList<ServiceDescriptor>();
        ServiceDescriptor[] services = profile.getInfo().getServices();
        for (int i = 0; i < services.length; ++i) {
            ServiceDescriptor service = services[i];
            if (!LegacyUtil.isMxService((ServiceDescriptor)service)) continue;
            mxServices.add(service);
        }
        return mxServices.toArray(new ServiceDescriptor[mxServices.size()]);
    }

    void unexportBlock(ApplicationContext context, ComponentProfile profile) {
        String name = profile.getMetaData().getName();
        try {
            context.unexportObject(name);
        }
        catch (Exception e) {
            String message = REZ.getString("unexport.error", (Object)name, (Object)e);
            this.getLogger().error(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

