/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.framework.tools.ant;

import com.thoughtworks.qdox.ant.AbstractQdoxTask;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avalon.phoenix.framework.info.ComponentInfo;
import org.apache.avalon.phoenix.framework.tools.ant.FormatEnum;
import org.apache.avalon.phoenix.framework.tools.infobuilder.InfoWriter;
import org.apache.avalon.phoenix.framework.tools.infobuilder.LegacyBlockInfoWriter;
import org.apache.avalon.phoenix.framework.tools.infobuilder.SerializedInfoWriter;
import org.apache.avalon.phoenix.framework.tools.infobuilder.XMLInfoWriter;
import org.apache.avalon.phoenix.framework.tools.qdox.AbstractInfoBuilder;
import org.apache.avalon.phoenix.framework.tools.qdox.DefaultInfoBuilder;
import org.apache.avalon.phoenix.framework.tools.qdox.LegacyInfoBuilder;
import org.apache.tools.ant.BuildException;

public class MetaGenerateTask
extends AbstractQdoxTask {
    public static final int XML_TYPE = 0;
    public static final int SER_TYPE = 1;
    public static final int LEGACY_TYPE = 2;
    private static final InfoWriter c_xmlWriter = new XMLInfoWriter();
    private static final InfoWriter c_serWriter = new SerializedInfoWriter();
    private static final InfoWriter c_legacyWriter = new LegacyBlockInfoWriter();
    private File m_destDir;
    private int m_format;
    private boolean m_force = false;

    public void setDestDir(File destDir) {
        this.m_destDir = destDir;
    }

    public void setFormat(FormatEnum format) {
        this.m_format = format.getTypeCode();
    }

    public void setForce(boolean force) {
        this.m_force = force;
    }

    public void execute() throws BuildException {
        this.validate();
        String message = "Writing Info descriptors as " + this.getOutputDescription() + ".";
        this.log(message);
        super.execute();
        try {
            this.writeInfoMetaData();
        }
        catch (Exception e) {
            throw new BuildException(e.toString(), (Throwable)e);
        }
    }

    private void validate() {
        if (null == this.m_destDir) {
            String message = "DestDir (" + this.m_destDir + ") not specified";
            throw new BuildException(message);
        }
        if (!this.m_destDir.isDirectory()) {
            String message = "DestDir (" + this.m_destDir + ") is not a directory.";
            throw new BuildException(message);
        }
        if (!this.m_destDir.exists() && !this.m_destDir.mkdirs()) {
            String message = "DestDir (" + this.m_destDir + ") could not be created.";
            throw new BuildException(message);
        }
    }

    private String getOutputDescription() {
        if (0 == this.m_format) {
            return "xml";
        }
        if (1 == this.m_format) {
            return "serialized objects";
        }
        return "legacy xml";
    }

    private void writeInfoMetaData() throws IOException {
        int size = this.allClasses.size();
        for (int i = 0; i < size; ++i) {
            AbstractInfoBuilder infoBuilder;
            JavaClass javaClass = (JavaClass)this.allClasses.get(i);
            ComponentInfo info = null;
            DocletTag tag = javaClass.getTagByName("phoenix.component");
            if (null != tag) {
                infoBuilder = new DefaultInfoBuilder();
                info = ((DefaultInfoBuilder)infoBuilder).buildComponentInfo(javaClass);
            } else {
                tag = javaClass.getTagByName("phoenix:block");
                if (null != tag) {
                    infoBuilder = new LegacyInfoBuilder();
                    info = ((LegacyInfoBuilder)infoBuilder).buildComponentInfo(javaClass);
                }
            }
            if (null == info) continue;
            String classname = javaClass.getFullyQualifiedName();
            File source = javaClass.getParentSource().getFile();
            File dest = this.getOutputFileForClass(classname);
            if (!this.m_force && dest.exists() && dest.lastModified() >= source.lastModified()) continue;
            File parent = dest.getParentFile();
            if (null != parent && !parent.exists() && !parent.mkdirs()) {
                String message = "Failed to create output directory: " + parent;
                throw new BuildException(message);
            }
            this.writeInfo(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInfo(ComponentInfo info) throws IOException {
        String fqn = info.getDescriptor().getImplementationKey();
        File file = this.getOutputFileForClass(fqn);
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            this.getInfoWriter().writeComponentInfo(info, outputStream);
        }
        catch (Exception e) {
            this.log("Error writing " + file + ". Cause: " + e);
        }
        finally {
            this.shutdownStream(outputStream);
        }
    }

    private InfoWriter getInfoWriter() {
        if (0 == this.m_format) {
            return c_xmlWriter;
        }
        if (1 == this.m_format) {
            return c_serWriter;
        }
        return c_legacyWriter;
    }

    private File getOutputFileForClass(String classname) throws IOException {
        String filename = classname.replace('.', File.separatorChar);
        filename = 0 == this.m_format ? filename + "-info.xml" : (1 == this.m_format ? filename + "-info.ser" : filename + ".xinfo");
        return new File(this.m_destDir, filename).getCanonicalFile();
    }

    private void shutdownStream(OutputStream outputStream) {
        if (null != outputStream) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected final File getDestDir() {
        return this.m_destDir;
    }
}

