/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.classman.runtime;

import java.io.IOException;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.Vector;

public class JoinClassLoader
extends SecureClassLoader {
    private final ClassLoader[] m_classLoaders;

    public JoinClassLoader(ClassLoader[] classLoaders, ClassLoader parent) {
        super(parent);
        if (null == classLoaders) {
            throw new NullPointerException("classLoaders");
        }
        int i = 0;
        while (i < classLoaders.length) {
            if (null == classLoaders[i]) {
                throw new NullPointerException("classLoaders[" + i + "]");
            }
            ++i;
        }
        this.m_classLoaders = classLoaders;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        int i = 0;
        while (i < this.m_classLoaders.length) {
            try {
                return this.m_classLoaders[i].loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++i;
            }
        }
        return super.findClass(name);
    }

    protected Enumeration findResources(String name) throws IOException {
        Enumeration<URL> resources;
        Vector result = new Vector();
        int i = 0;
        while (i < this.m_classLoaders.length) {
            try {
                resources = this.m_classLoaders[i].getResources(name);
                this.addAll(result, resources);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            ++i;
        }
        resources = super.findResources(name);
        this.addAll(result, resources);
        return result.elements();
    }

    private void addAll(Vector result, Enumeration resources) {
        while (resources.hasMoreElements()) {
            result.add(resources.nextElement());
        }
    }

    protected URL findResource(String name) {
        int i = 0;
        while (i < this.m_classLoaders.length) {
            URL resource = this.m_classLoaders[i].getResource(name);
            if (null != resource) {
                return resource;
            }
            ++i;
        }
        return super.findResource(name);
    }
}

