/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.components.manager;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.phoenix.components.manager.AbstractSystemManager;
import org.apache.avalon.phoenix.components.manager.MBeanInfoBuilder;
import org.apache.avalon.phoenix.components.manager.Target;
import org.apache.avalon.phoenix.interfaces.ManagerException;

public abstract class AbstractJMXManager
extends AbstractSystemManager {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$components$manager$AbstractJMXManager == null ? (class$org$apache$avalon$phoenix$components$manager$AbstractJMXManager = AbstractJMXManager.class$("org.apache.avalon.phoenix.components.manager.AbstractJMXManager")) : class$org$apache$avalon$phoenix$components$manager$AbstractJMXManager));
    private MBeanInfoBuilder topicBuilder;
    private MBeanServer m_mBeanServer;
    private String m_domain = "Phoenix";
    static /* synthetic */ Class class$org$apache$avalon$phoenix$components$manager$AbstractJMXManager;
    static /* synthetic */ Class class$java$lang$Object;

    public void initialize() throws Exception {
        super.initialize();
        MBeanServer mBeanServer = this.createMBeanServer();
        this.setMBeanServer(mBeanServer);
        this.topicBuilder = new MBeanInfoBuilder();
        this.setupLogger((Object)this.topicBuilder);
    }

    public void dispose() {
        this.setMBeanServer(null);
        super.dispose();
    }

    protected Object export(String name, Object object, Class[] interfaces) throws ManagerException {
        try {
            Target target = this.createTarget(name, object, interfaces);
            this.exportTarget(target);
            return target;
        }
        catch (Exception e) {
            String message = REZ.getString("jmxmanager.error.export.fail", (Object)name);
            this.getLogger().error(message, (Throwable)e);
            throw new ManagerException(message, e);
        }
    }

    protected void unexport(String name, Object exportedObject) throws ManagerException {
        try {
            Target target = (Target)exportedObject;
            Set topicNames = target.getTopicNames();
            Iterator i = topicNames.iterator();
            while (i.hasNext()) {
                ObjectName objectName = this.createObjectName(name, target.getTopic((String)i.next()));
                this.getMBeanServer().unregisterMBean(objectName);
            }
        }
        catch (Exception e) {
            String message = REZ.getString("jmxmanager.error.unexport.fail", (Object)name);
            this.getLogger().error(message, (Throwable)e);
            throw new ManagerException(message, e);
        }
    }

    protected void verifyInterface(Class clazz) throws ManagerException {
    }

    protected MBeanServer getMBeanServer() {
        return this.m_mBeanServer;
    }

    protected void setMBeanServer(MBeanServer mBeanServer) {
        this.m_mBeanServer = mBeanServer;
    }

    protected String getDomain() {
        return this.m_domain;
    }

    protected void setDomain(String domain) {
        this.m_domain = domain;
    }

    protected abstract MBeanServer createMBeanServer() throws Exception;

    protected Target createTarget(String name, Object object, Class[] interfaces) {
        Target target = new Target(name, object);
        try {
            this.topicBuilder.build(target, object.getClass(), interfaces);
        }
        catch (Exception e) {
            this.getLogger().debug(e.getMessage(), (Throwable)e);
        }
        return target;
    }

    protected void exportTarget(Target target) throws Exception {
        Set topicNames = target.getTopicNames();
        Iterator i = topicNames.iterator();
        while (i.hasNext()) {
            Object managedResource;
            String topicName = (String)i.next();
            ModelMBeanInfo topic = target.getTopic(topicName);
            String targetName = target.getName();
            Object targetObject = managedResource = target.getManagedResource();
            if (topic.getMBeanDescriptor().getFieldValue("proxyClassName") != null) {
                targetObject = this.createManagementProxy(topic, managedResource);
            }
            this.exportTopic(topic, targetObject, targetName);
        }
    }

    protected Object exportTopic(ModelMBeanInfo topic, Object target, String targetName) throws Exception {
        Object mBean = this.createMBean(topic, target);
        ObjectName objectName = this.createObjectName(targetName, topic);
        this.getMBeanServer().registerMBean(mBean, objectName);
        return mBean;
    }

    private Object createMBean(ModelMBeanInfo topic, Object target) throws ManagerException {
        ModelMBean mbean;
        Class<?> clazz;
        String className = topic.getClassName();
        try {
            clazz = Class.forName(className);
        }
        catch (Exception e) {
            String message = REZ.getString("jmxmanager.error.mbean.load.class", (Object)className);
            this.getLogger().error(message, (Throwable)e);
            throw new ManagerException(message, e);
        }
        try {
            mbean = (ModelMBean)clazz.newInstance();
            mbean.setModelMBeanInfo(topic);
        }
        catch (Exception e) {
            String message = REZ.getString("jmxmanager.error.mbean.instantiate", (Object)className);
            this.getLogger().error(message, (Throwable)e);
            throw new ManagerException(message, e);
        }
        try {
            if (null != target) {
                mbean.setManagedResource(target, "ObjectReference");
            }
        }
        catch (Exception e) {
            String message = REZ.getString("jmxmanager.error.mbean.set.resource", (Object)className);
            this.getLogger().error(message, (Throwable)e);
            throw new ManagerException(message, e);
        }
        return mbean;
    }

    private ObjectName createObjectName(String name, ModelMBeanInfo topic) throws MalformedObjectNameException {
        return new ObjectName(this.getDomain() + ":" + name + ",topic=" + topic.getDescription());
    }

    private Object createManagementProxy(ModelMBeanInfo topic, Object managedObject) throws Exception {
        String proxyClassname = (String)topic.getMBeanDescriptor().getFieldValue("proxyClassName");
        ClassLoader classLoader = managedObject.getClass().getClassLoader();
        Class<?> proxyClass = classLoader.loadClass(proxyClassname);
        Class[] argTypes = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = AbstractJMXManager.class$("java.lang.Object")) : class$java$lang$Object};
        Object[] argValues = new Object[]{managedObject};
        Constructor<?> constructor = proxyClass.getConstructor(argTypes);
        return constructor.newInstance(argValues);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

