/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.salt.i18n;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.realityforge.salt.i18n.Resources;

public class ResourceManager {
    private static final String POSTFIX = ".Resources";
    private static final RuntimePermission CLEAR_CACHE_PERMISSION;
    private static final Map c_resources;

    public static final synchronized void clearResourceCache() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (null != sm) {
            sm.checkPermission(CLEAR_CACHE_PERMISSION);
        }
        c_resources.clear();
    }

    public static final Resources getBaseResources(String basename, ClassLoader classLoader) {
        Resources resources = ResourceManager.getCachedResource(basename, classLoader);
        if (null == resources) {
            resources = new Resources(basename, classLoader);
            ResourceManager.putCachedResource(basename, classLoader, resources);
        }
        return resources;
    }

    public static final Resources getResources(String resource, ClassLoader classLoader) {
        return ResourceManager.getBaseResources(resource + POSTFIX, classLoader);
    }

    public static final Resources getPackageResources(Class clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(".");
        if (-1 != index) {
            name = name.substring(0, index);
        }
        if (!name.equals("")) {
            name = name + POSTFIX;
        }
        return ResourceManager.getBaseResources(name, clazz.getClassLoader());
    }

    public static final Resources getClassResources(Class clazz) {
        String resource = clazz.getName() + POSTFIX;
        return ResourceManager.getBaseResources(resource, clazz.getClassLoader());
    }

    private static final synchronized void putCachedResource(String baseName, ClassLoader classLoader, Resources resources) {
        HashMap<String, WeakReference<Resources>> map = (HashMap<String, WeakReference<Resources>>)c_resources.get(classLoader);
        if (null == map) {
            map = new HashMap<String, WeakReference<Resources>>();
            c_resources.put(classLoader, map);
        }
        map.put(baseName, new WeakReference<Resources>(resources));
    }

    private static final synchronized Resources getCachedResource(String baseName, ClassLoader classLoader) {
        Map map = (Map)c_resources.get(classLoader);
        if (null == map) {
            return null;
        }
        WeakReference weakReference = (WeakReference)map.get(baseName);
        if (null == weakReference) {
            return null;
        }
        return (Resources)weakReference.get();
    }

    static {
        POSTFIX = POSTFIX;
        CLEAR_CACHE_PERMISSION = new RuntimePermission("i18n.clearCompleteCache");
        c_resources = new WeakHashMap();
    }
}

