/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.launcher;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class LauncherUtils {
    private static final String LOADER_JAR = "phoenix-loader.jar";

    static URL[] getEngineClassPath() throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        File dir = LauncherUtils.findEngineLibDir();
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.getName().endsWith(".jar")) continue;
            urls.add(file.toURL());
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static File findEngineLibDir() throws Exception {
        String phoenixHome = LauncherUtils.findPhoenixHome();
        String engineLibDir = phoenixHome + File.separator + "bin" + File.separator + "lib";
        File dir = new File(engineLibDir).getCanonicalFile();
        if (!dir.exists()) {
            throw new Exception("Unable to locate engine lib directory at " + engineLibDir);
        }
        return dir;
    }

    static String findPhoenixHome() throws Exception {
        String phoenixHome = System.getProperty("phoenix.home", null);
        if (null == phoenixHome) {
            File loaderDir = LauncherUtils.findLoaderDir();
            phoenixHome = loaderDir.getAbsoluteFile().getParentFile() + File.separator;
        }
        phoenixHome = new File(phoenixHome).getCanonicalFile().toString();
        System.setProperty("phoenix.home", phoenixHome);
        return phoenixHome;
    }

    private static final File findLoaderDir() throws Exception {
        String classpath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(classpath, pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String element = tokenizer.nextToken();
            if (!element.endsWith(LOADER_JAR)) continue;
            File file = new File(element).getCanonicalFile();
            file = file.getParentFile();
            return file;
        }
        throw new Exception("Unable to locate phoenix-loader.jar in classpath. User must specify phoenix.home system property.");
    }
}

