/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.configkit;

import java.util.List;
import org.realityforge.configkit.EntityInfo;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class CatalogHandler
extends DefaultHandler {
    private final List m_entitys;

    CatalogHandler(List entitys) {
        if (null == entitys) {
            throw new NullPointerException("entitys");
        }
        this.m_entitys = entitys;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("catalog".equals(qName)) {
            String version = attributes.getValue("version");
            if (null == version) {
                String message = "'version' attribute must be specified for catalog element.";
                throw new SAXException("'version' attribute must be specified for catalog element.");
            }
            if (!"1.0".equals(version)) {
                String message = "'version' attribute must have value of '1.0' for catalog element.";
                throw new SAXException("'version' attribute must have value of '1.0' for catalog element.");
            }
        } else if ("entity".equals(qName)) {
            String publicId = attributes.getValue("publicId");
            String systemId = attributes.getValue("systemId");
            String resource = attributes.getValue("resource");
            if (null == publicId && null == systemId) {
                String message = "One of publicId or systemId attributes must be specified for entity element.";
                throw new SAXException("One of publicId or systemId attributes must be specified for entity element.");
            }
            if (null == resource) {
                String message = "resource attribute must be specified for entity element.";
                throw new SAXException("resource attribute must be specified for entity element.");
            }
            this.m_entitys.add(new EntityInfo(publicId, systemId, resource));
        } else {
            String message = "unknown element " + qName + ".";
            throw new SAXException(message);
        }
    }
}

