/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.decorator;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.excalibur.logger.decorator.LoggerManagerDecorator;
import org.apache.avalon.framework.logger.Logger;

public class CachingDecorator
extends LoggerManagerDecorator {
    private final Map m_loggers = new HashMap();
    private Logger m_defaultLogger = null;

    public CachingDecorator(LoggerManager loggerManager) {
        super(loggerManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLoggerForCategory(String categoryName) {
        Map map = this.m_loggers;
        synchronized (map) {
            Logger logger = (Logger)this.m_loggers.get(categoryName);
            if (logger == null) {
                logger = this.m_loggerManager.getLoggerForCategory(categoryName);
                if (logger == null) {
                    String message = "getLoggerForCategory('" + categoryName + "')";
                    throw new NullPointerException(message);
                }
                this.m_loggers.put(categoryName, logger);
            }
            return logger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getDefaultLogger() {
        CachingDecorator cachingDecorator = this;
        synchronized (cachingDecorator) {
            if (this.m_defaultLogger == null) {
                this.m_defaultLogger = this.m_loggerManager.getDefaultLogger();
                if (this.m_defaultLogger == null) {
                    throw new NullPointerException("getDefaultLogger()");
                }
            }
            return this.m_defaultLogger;
        }
    }
}

