/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.xmlpolicy.runtime;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.realityforge.salt.io.FileUtil;
import org.realityforge.xmlpolicy.runtime.PolicyEntry;

public abstract class AbstractPolicy
extends Policy {
    private final ArrayList m_entries = new ArrayList();

    public PermissionCollection getPermissions(CodeSource codeSource) {
        CodeSource target = this.normalize(codeSource);
        Permissions permissions = new Permissions();
        int size = this.m_entries.size();
        int i = 0;
        while (i < size) {
            PolicyEntry entry = (PolicyEntry)this.m_entries.get(i);
            if (entry.getCodeSource().implies(target)) {
                this.copyPermissions(permissions, entry.getPermissions());
            }
            ++i;
        }
        return permissions;
    }

    public void refresh() {
    }

    protected Permissions createPermissionSetFor(CodeSource codeSource) {
        CodeSource target = this.normalize(codeSource);
        PolicyEntry entry = new PolicyEntry(target, new Permissions());
        this.m_entries.add(entry);
        return entry.getPermissions();
    }

    private CodeSource normalize(CodeSource codeSource) {
        URL initialLocation = codeSource.getLocation();
        if (null == initialLocation) {
            return codeSource;
        }
        String location = null;
        if (!initialLocation.getProtocol().equalsIgnoreCase("file")) {
            location = initialLocation.getFile();
            location = FileUtil.normalize((String)location);
        } else {
            File file = new File(initialLocation.getFile());
            location = file.getAbsoluteFile().toString().replace(File.separatorChar, '/');
            location = FileUtil.normalize((String)location);
        }
        URL finalLocation = null;
        try {
            finalLocation = new URL(initialLocation.getProtocol(), initialLocation.getHost(), initialLocation.getPort(), location);
        }
        catch (MalformedURLException mue) {
            this.error("Error building codeBase", mue);
        }
        Certificate[] certificates = codeSource.getCertificates();
        return new CodeSource(finalLocation, certificates);
    }

    private void copyPermissions(Permissions destination, Permissions source) {
        Enumeration<Permission> enumeration = source.elements();
        while (enumeration.hasMoreElements()) {
            destination.add(enumeration.nextElement());
        }
    }

    protected void error(String message, Throwable throwable) {
        System.err.println(message);
    }
}

