/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.james.util.watchdog;

import org.apache.avalon.excalibur.pool.DefaultPool;
import org.apache.avalon.excalibur.pool.HardResourceLimitingPool;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.excalibur.thread.ThreadPool;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;

/**
 * This class is a factory to produce Watchdogs, each of which is associated
 * with a single thread.
 *
 */
public class ThreadPerWatchdogFactory
    extends AbstractLogEnabled
    implements WatchdogFactory {

    /**
     * The thread pool used to generate InaccurateTimeoutWatchdogs
     */
    private ThreadPool myThreadPool;

    /**
     * The watchdog timeout for Watchdogs generated by this factory
     */
    private long timeout;

    /**
     * Creates the factory and sets the thread pool used to generate
     * InaccurateTimeoutWatchdogs.
     */
    public ThreadPerWatchdogFactory(ThreadPool theThreadPool, long timeout) {
        if (theThreadPool == null) {
            throw new IllegalArgumentException("The thread pool for the ThreadPerWatchdogFactory cannot be null.");
        }
        myThreadPool = theThreadPool;
        this.timeout = timeout;
    }

    /**
     * @see org.apache.james.util.watchdog.WatchdogFactory#getWatchdog(WatchdogTarget)
     */
    public Watchdog getWatchdog(WatchdogTarget theTarget)
            throws Exception {
        InaccurateTimeoutWatchdog watchdog = new InaccurateTimeoutWatchdog(timeout, theTarget, myThreadPool);
        watchdog.enableLogging(getLogger());
        return watchdog;
    }
}
