/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.phoenix.framework.tools.verifier;

import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.framework.info.ComponentInfo;
import org.apache.avalon.phoenix.framework.info.ContextDescriptor;
import org.apache.avalon.phoenix.framework.info.SchemaDescriptor;
import org.apache.avalon.phoenix.framework.info.ServiceDescriptor;
import org.apache.avalon.phoenix.framework.tools.verifier.ComponentVerifier;
import org.apache.avalon.phoenix.framework.tools.verifier.VerifyException;

public class InfoVerifier
extends AbstractLogEnabled {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$phoenix$framework$tools$verifier$InfoVerifier == null ? (class$org$apache$avalon$phoenix$framework$tools$verifier$InfoVerifier = InfoVerifier.class$("org.apache.avalon.phoenix.framework.tools.verifier.InfoVerifier")) : class$org$apache$avalon$phoenix$framework$tools$verifier$InfoVerifier));
    private final ComponentVerifier m_verifier;
    static /* synthetic */ Class class$org$apache$avalon$phoenix$framework$tools$verifier$InfoVerifier;
    static /* synthetic */ Class class$org$apache$avalon$framework$configuration$Configurable;
    static /* synthetic */ Class class$org$apache$avalon$framework$parameters$Parameterizable;
    static /* synthetic */ Class class$org$apache$avalon$framework$context$Contextualizable;
    static /* synthetic */ Class class$org$apache$avalon$framework$component$Composable;
    static /* synthetic */ Class class$org$apache$avalon$framework$service$Serviceable;

    public InfoVerifier() {
        this(new ComponentVerifier());
    }

    public InfoVerifier(ComponentVerifier verifier) {
        if (null == verifier) {
            throw new NullPointerException("verifier");
        }
        this.m_verifier = verifier;
    }

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.setupLogger((Object)this.m_verifier);
    }

    public void verifyType(String name, String implementationKey, ComponentInfo info, ClassLoader classLoader) throws VerifyException {
        Class clazz = this.getClass(classLoader, name, implementationKey);
        this.verifyType(name, implementationKey, info, clazz);
    }

    public void verifyType(String name, String implementationKey, ComponentInfo info, Class implementation) throws VerifyException {
        Class[] interfaces = this.getServiceClasses(name, info.getServices(), implementation.getClassLoader());
        this.m_verifier.verifyComponent(name, implementation, interfaces, false);
        this.verifyDependencyPresence(name, implementationKey, info, implementation);
        this.verifyContextPresence(name, implementationKey, info, implementation);
        this.verifyConfigurationSchemaPresence(name, implementationKey, info, implementation);
        this.verifyParametersSchemaPresence(name, implementationKey, info, implementation);
    }

    protected void verifyConfigurationSchemaPresence(String name, String implementationKey, ComponentInfo info, Class implementation) throws VerifyException {
        SchemaDescriptor schema = info.getConfigurationSchema();
        if (null == schema) {
            return;
        }
        if (!(class$org$apache$avalon$framework$configuration$Configurable == null ? (class$org$apache$avalon$framework$configuration$Configurable = InfoVerifier.class$("org.apache.avalon.framework.configuration.Configurable")) : class$org$apache$avalon$framework$configuration$Configurable).isAssignableFrom(implementation)) {
            String message = REZ.getString("metadata.declare-uneeded-configuration-schema.error", (Object)name, (Object)implementationKey);
            throw new VerifyException(message);
        }
    }

    protected void verifyParametersSchemaPresence(String name, String implementationKey, ComponentInfo info, Class implementation) throws VerifyException {
        SchemaDescriptor schema = info.getParametersSchema();
        if (null == schema) {
            return;
        }
        if (!(class$org$apache$avalon$framework$parameters$Parameterizable == null ? (class$org$apache$avalon$framework$parameters$Parameterizable = InfoVerifier.class$("org.apache.avalon.framework.parameters.Parameterizable")) : class$org$apache$avalon$framework$parameters$Parameterizable).isAssignableFrom(implementation)) {
            String message = REZ.getString("metadata.declare-uneeded-parameter-schema.error", (Object)name, (Object)implementationKey);
            throw new VerifyException(message);
        }
    }

    protected void verifyContextPresence(String name, String implementationKey, ComponentInfo info, Class implementation) throws VerifyException {
        ContextDescriptor context = info.getContext();
        int count = context.getEntrys().length;
        if (!(class$org$apache$avalon$framework$context$Contextualizable == null ? (class$org$apache$avalon$framework$context$Contextualizable = InfoVerifier.class$("org.apache.avalon.framework.context.Contextualizable")) : class$org$apache$avalon$framework$context$Contextualizable).isAssignableFrom(implementation) && 0 != count) {
            String message = REZ.getString("metadata.declare-uneeded-entrys.error", (Object)name, (Object)implementationKey);
            throw new VerifyException(message);
        }
    }

    protected void verifyDependencyPresence(String name, String implementationKey, ComponentInfo info, Class implementation) throws VerifyException {
        boolean aquiresServices;
        int count = info.getDependencies().length;
        boolean bl = (class$org$apache$avalon$framework$component$Composable == null ? (class$org$apache$avalon$framework$component$Composable = InfoVerifier.class$("org.apache.avalon.framework.component.Composable")) : class$org$apache$avalon$framework$component$Composable).isAssignableFrom(implementation) || (class$org$apache$avalon$framework$service$Serviceable == null ? (class$org$apache$avalon$framework$service$Serviceable = InfoVerifier.class$("org.apache.avalon.framework.service.Serviceable")) : class$org$apache$avalon$framework$service$Serviceable).isAssignableFrom(implementation) ? true : (aquiresServices = false);
        if (!aquiresServices && 0 != count) {
            String message = REZ.getString("metadata.declare-uneeded-deps.error", (Object)name, (Object)implementationKey);
            throw new VerifyException(message);
        }
    }

    protected Class[] getServiceClasses(String name, ServiceDescriptor[] services, ClassLoader classLoader) throws VerifyException {
        Class[] classes = new Class[services.length];
        for (int i = 0; i < services.length; ++i) {
            String classname = services[i].getType();
            try {
                classes[i] = classLoader.loadClass(classname);
                continue;
            }
            catch (Throwable t) {
                String message = REZ.getString("metadata.bad-service-class.error", (Object)name, (Object)classname, (Object)t.toString());
                throw new VerifyException(message, t);
            }
        }
        return classes;
    }

    private Class getClass(ClassLoader classLoader, String name, String implementationKey) throws VerifyException {
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(implementationKey);
        }
        catch (Exception e) {
            String message = REZ.getString("assembly.bad-class.error", (Object)name, (Object)implementationKey, (Object)e.toString());
            throw new VerifyException(message);
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

