/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc.util;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class Pool {
    private static final Pool instance = new Pool();
    private Map poolArrays;

    public static Pool getInstance() {
        return instance;
    }

    public Object[] getPool(String name) {
        return (Object[])this.getPoolArrays().get(name);
    }

    public Map getPoolArrays() {
        if (this.poolArrays == null) {
            this.poolArrays = new HashMap();
        }
        return this.poolArrays;
    }

    public Object[] addPool(String name, Class type, int instance_count) {
        return this.addPool(name, type, instance_count, null);
    }

    public Object[] addPool(String name, Class type, int instance_count, Object[] existing_pool) {
        if (instance_count == 0) {
            throw new IllegalArgumentException("instance_count can't be 0.");
        }
        int pool_size = instance_count + (existing_pool != null ? existing_pool.length : 0);
        Object[] pool_array = (Object[])Array.newInstance(type, pool_size);
        if (existing_pool != null) {
            System.arraycopy(existing_pool, 0, pool_array, 0, existing_pool.length);
        }
        int i = 0;
        while (i < instance_count) {
            try {
                pool_array[i] = type.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.getPoolArrays().put(name, pool_array);
        return pool_array;
    }

    public Object[] increasePool(String name, int increase) {
        Object[] existing_pool_array = (Object[])this.getPoolArrays().get(name);
        if (existing_pool_array == null) {
            throw new IllegalStateException("Trying to increase the pool when it doesn not exist.");
        }
        Class<?> type = existing_pool_array[0].getClass();
        int existing_instance_count = existing_pool_array.length;
        return this.addPool(name, type, existing_instance_count + increase, existing_pool_array);
    }

    public void removeAllPools() {
        this.poolArrays = null;
    }
}

