/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import xjavadoc.Util;

public final class SourceSet
implements Serializable {
    private static final Log _log = LogFactory.getLog((String)(class$xjavadoc$SourceSet == null ? (class$xjavadoc$SourceSet = SourceSet.class$("xjavadoc.SourceSet")) : class$xjavadoc$SourceSet).getName());
    private File _dir;
    private ArrayList _files;
    private int hash = Integer.MIN_VALUE;
    static /* synthetic */ Class class$xjavadoc$SourceSet;

    public SourceSet(File dir, String[] files) {
        if (dir == null) {
            throw new IllegalArgumentException("dir can't be null");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("dir must be a directory");
        }
        this._dir = dir;
        this._files = new ArrayList();
        if (files != null) {
            this._files.addAll(Arrays.asList(files));
        }
    }

    public SourceSet(File fileOrDir) {
        this._files = new ArrayList();
        if (fileOrDir.isDirectory()) {
            this._dir = fileOrDir;
            this._files.addAll(Arrays.asList(Util.getJavaFiles(fileOrDir)));
        } else {
            this._dir = fileOrDir.getParentFile();
            this._files.add(fileOrDir.getName());
        }
    }

    public File getDir() {
        return this._dir;
    }

    public String[] getFiles() {
        return this._files.size() == 0 ? null : this._files.toArray(new String[this._files.size()]);
    }

    public File getSourceFile(String qualifiedName) {
        File sourceFile = new File(this._dir, this.getRelativeFileName(qualifiedName));
        if (!sourceFile.exists()) {
            sourceFile = null;
        }
        return sourceFile;
    }

    public String getQualifiedName(int i) {
        return this.getQualifiedName((String)this._files.get(i));
    }

    public int getSize() {
        return this._files.size();
    }

    public boolean containsAbsolute(String filename) {
        return filename.startsWith(this.getDir().getPath()) && this._files.contains(filename.substring(this.getDir().getPath().length() + 1));
    }

    public boolean containsRelative(String filename) {
        return this._files.contains(filename);
    }

    public boolean equals(Object o) {
        if (o instanceof SourceSet) {
            SourceSet other = (SourceSet)o;
            return this._dir.equals(other._dir) && this._files.equals(other._files);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == Integer.MIN_VALUE) {
            this.hash = this._dir.hashCode();
            if (this._files != null) {
                int i = 0;
                while (i < this._files.size()) {
                    this.hash += this._files.get(i).hashCode();
                    ++i;
                }
            }
        }
        return this.hash;
    }

    private String getQualifiedName(String relativeFileName) {
        String result = relativeFileName.replace('/', '.').replace('\\', '.');
        result = result.substring(0, result.length() - 5);
        return result;
    }

    private String getRelativeFileName(String qualifiedName) {
        return qualifiedName.replace('.', File.separatorChar) + ".java";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DirectoryFilter
    implements FileFilter {
        DirectoryFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }

    class JavaSourceFilter
    implements FileFilter {
        private static final String suffix = ".java";

        JavaSourceFilter() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith(suffix);
        }

        static {
            suffix = suffix;
        }
    }
}

