/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.sockets;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.avalon.cornerstone.blocks.sockets.AbstractTLSSocketFactory;
import org.apache.avalon.cornerstone.blocks.sockets.SSLFactoryBuilder;
import org.apache.avalon.cornerstone.services.sockets.SocketFactory;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Contextualizable;

public class TLSSocketFactory
extends AbstractTLSSocketFactory
implements SocketFactory,
Contextualizable,
Configurable,
Initializable {
    private SSLSocketFactory m_factory;
    private boolean m_verifyServerIdentity;

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.m_verifyServerIdentity = configuration.getChild("verify-server-identity").getValueAsBoolean(false);
    }

    protected void visitBuilder(SSLFactoryBuilder builder) {
        this.m_factory = builder.buildSocketFactory();
    }

    private Socket initSocket(Socket socket) throws IOException {
        socket.setSoTimeout(this.m_socketTimeOut);
        return socket;
    }

    private SSLSocket sslWrap(Socket bareSocket, InetAddress address, int port) throws IOException {
        String hostName = address.getHostName();
        SSLSocket sslSocket = (SSLSocket)this.m_factory.createSocket(bareSocket, hostName, port, true);
        sslSocket.startHandshake();
        SSLSession session = sslSocket.getSession();
        String DN = session.getPeerCertificateChain()[0].getSubjectDN().getName();
        String CN = this.getCN(DN);
        if (!hostName.equals(CN)) {
            String message = "Host name mismatch, expected '" + hostName + "' recevied DN is " + DN;
            throw new IOException(message);
        }
        if (this.getLogger().isDebugEnabled()) {
            String message = "DN of the server " + DN;
            this.getLogger().debug(message);
            String message2 = "Session id " + this.bytesToString(session.getId());
            this.getLogger().debug(message2);
        }
        return sslSocket;
    }

    private StringBuffer bytesToString(byte[] data) {
        StringBuffer result = new StringBuffer(data.length * 3);
        String sep = "";
        for (int i = 0; i < data.length; ++i) {
            int signedValue = data[i];
            int unsignedByteValue = signedValue >= 0 ? signedValue : 256 + signedValue;
            result.append(sep).append(Integer.toHexString(unsignedByteValue));
            sep = ":";
        }
        return result;
    }

    private String getCN(String DN) {
        int startOfCN = DN.indexOf("CN=");
        if (startOfCN < 0) {
            return null;
        }
        int startOfHostName = startOfCN + "CN=".length();
        int endOfHostName = DN.indexOf(44, startOfHostName);
        if (endOfHostName > 0) {
            return DN.substring(startOfHostName, endOfHostName);
        }
        return null;
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        if (this.m_verifyServerIdentity) {
            return this.sslWrap(this.initSocket(new Socket(address, port)), address, port);
        }
        return this.initSocket(this.m_factory.createSocket(address, port));
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        if (this.m_verifyServerIdentity) {
            return this.sslWrap(this.initSocket(new Socket(address, port, localAddress, localPort)), address, port);
        }
        return this.initSocket(this.m_factory.createSocket(address, port));
    }
}

