/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.sockets;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.avalon.cornerstone.blocks.sockets.AbstractTLSSocketFactory;
import org.apache.avalon.cornerstone.blocks.sockets.SSLFactoryBuilder;
import org.apache.avalon.cornerstone.services.sockets.ServerSocketFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class TLSServerSocketFactory
extends AbstractTLSSocketFactory
implements ServerSocketFactory {
    private SSLServerSocketFactory m_factory;
    protected boolean m_keyStoreAuthenticateClients;

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.m_keyStoreAuthenticateClients = configuration.getChild("authenticate-client").getValueAsBoolean(false);
    }

    protected void visitBuilder(SSLFactoryBuilder builder) {
        this.m_factory = builder.buildServerSocketFactory();
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket serverSocket = this.m_factory.createServerSocket(port);
        this.initServerSocket(serverSocket);
        return serverSocket;
    }

    public ServerSocket createServerSocket(int port, int backLog) throws IOException {
        ServerSocket serverSocket = this.m_factory.createServerSocket(port, backLog);
        this.initServerSocket(serverSocket);
        return serverSocket;
    }

    public ServerSocket createServerSocket(int port, int backLog, InetAddress bindAddress) throws IOException {
        ServerSocket serverSocket = this.m_factory.createServerSocket(port, backLog, bindAddress);
        this.initServerSocket(serverSocket);
        return serverSocket;
    }

    protected void initServerSocket(ServerSocket serverSocket) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)serverSocket;
        socket.setNeedClientAuth(this.m_keyStoreAuthenticateClients);
        socket.setSoTimeout(this.m_socketTimeOut);
    }
}

