/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.sockets;

import org.apache.avalon.cornerstone.blocks.sockets.SSLFactoryBuilder;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;

public abstract class AbstractTLSSocketFactory
extends AbstractLogEnabled
implements Contextualizable,
Configurable,
Initializable {
    private static final int WAIT_FOREVER = 0;
    protected int m_socketTimeOut;
    private Context m_context;
    private Configuration m_childConfig;

    public void contextualize(Context context) {
        this.m_context = context;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_socketTimeOut = configuration.getChild("timeout").getValueAsInteger(0);
        this.m_childConfig = configuration.getChild("ssl-factory", false);
        if (this.m_childConfig == null) {
            String message = "ssl-factory child not found, please update your configuration according to the documentation. Reverting to the old configuration format.";
            this.getLogger().warn("ssl-factory child not found, please update your configuration according to the documentation. Reverting to the old configuration format.");
            this.m_childConfig = configuration;
        }
    }

    public void initialize() throws Exception {
        SSLFactoryBuilder builder = new SSLFactoryBuilder();
        this.setupLogger((Object)builder);
        ContainerUtil.contextualize((Object)((Object)builder), (Context)this.m_context);
        ContainerUtil.configure((Object)((Object)builder), (Configuration)this.m_childConfig);
        ContainerUtil.initialize((Object)((Object)builder));
        this.visitBuilder(builder);
        ContainerUtil.shutdown((Object)((Object)builder));
        this.m_context = null;
        this.m_childConfig = null;
    }

    protected abstract void visitBuilder(SSLFactoryBuilder var1);
}

