/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.LimitReader;

final class ReaderToUTF8Stream
extends InputStream {
    private LimitReader reader;
    private byte[] buffer;
    private int boff;
    private int blen;
    private boolean eof;
    private boolean multipleBuffer;
    private static final int BUFSIZE = 32768;

    ReaderToUTF8Stream(LimitReader limitReader) {
        this.reader = limitReader;
        this.buffer = new byte[32768];
        this.blen = -1;
    }

    public int read() throws IOException {
        if (this.buffer == null) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S"));
        }
        if (this.blen < 0) {
            this.fillBuffer(2);
        }
        while (this.boff == this.blen) {
            if (this.eof) {
                this.close();
                return -1;
            }
            this.fillBuffer(0);
        }
        return this.buffer[this.boff++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.buffer == null) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S"));
        }
        if (this.blen < 0) {
            this.fillBuffer(2);
        }
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.blen - this.boff;
            if (n4 == 0) {
                if (this.eof) {
                    if (n3 > 0) {
                        return n3;
                    }
                    this.close();
                    return -1;
                }
                this.fillBuffer(0);
                continue;
            }
            if (n2 < n4) {
                n4 = n2;
            }
            System.arraycopy(this.buffer, this.boff, byArray, n, n4);
            this.boff += n4;
            n2 -= n4;
            n3 += n4;
        }
        return n3;
    }

    private void fillBuffer(int n) throws IOException {
        this.boff = n;
        int n2 = this.boff;
        if (n2 == 0) {
            this.multipleBuffer = true;
        }
        while (n2 <= this.buffer.length - 6) {
            int n3 = this.reader.read();
            if (n3 < 0) {
                this.eof = true;
                break;
            }
            if (n3 >= 1 && n3 <= 127) {
                this.buffer[n2++] = (byte)n3;
                continue;
            }
            if (n3 > 2047) {
                this.buffer[n2++] = (byte)(0xE0 | n3 >> 12 & 0xF);
                this.buffer[n2++] = (byte)(0x80 | n3 >> 6 & 0x3F);
                this.buffer[n2++] = (byte)(0x80 | n3 >> 0 & 0x3F);
                continue;
            }
            this.buffer[n2++] = (byte)(0xC0 | n3 >> 6 & 0x1F);
            this.buffer[n2++] = (byte)(0x80 | n3 >> 0 & 0x3F);
        }
        this.blen = n2;
        this.boff = 0;
        if (this.eof) {
            this.checkSufficientData();
        }
    }

    private void checkSufficientData() throws IOException {
        int n;
        int n2 = this.reader.clearLimit();
        if (n2 > 0) {
            throw new IOException(MessageService.getTextMessage("XJ023.S"));
        }
        if (n2 == 0) {
            try {
                n = this.reader.read();
            }
            catch (IOException iOException) {
                n = -1;
            }
            if (n >= 0) {
                throw new IOException(MessageService.getTextMessage("XJ023.S"));
            }
        }
        if (!this.multipleBuffer) {
            n = this.blen - 2;
            this.buffer[0] = (byte)(n >>> 8 & 0xFF);
            this.buffer[1] = (byte)(n >>> 0 & 0xFF);
        } else {
            this.buffer[this.blen++] = -32;
            this.buffer[this.blen++] = 0;
            this.buffer[this.blen++] = 0;
        }
    }

    public void close() throws IOException {
        this.buffer = null;
    }

    public final int available() {
        int n = this.reader.getLimit();
        return 32768 > n ? n : 32768;
    }
}

