/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.services.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import org.apache.avalon.cornerstone.services.connection.ConnectionHandlerFactory;
import org.apache.avalon.cornerstone.services.connection.ConnectionManager;
import org.apache.avalon.cornerstone.services.sockets.ServerSocketFactory;
import org.apache.avalon.cornerstone.services.sockets.SocketManager;
import org.apache.avalon.cornerstone.services.threads.ThreadManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.WrapperComponentManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.thread.ThreadPool;

public abstract class AbstractService
extends AbstractLogEnabled
implements Contextualizable,
Serviceable,
Configurable,
Initializable,
Disposable {
    protected ConnectionManager m_connectionManager;
    protected SocketManager m_socketManager;
    protected ConnectionHandlerFactory m_factory = this.createFactory();
    protected ThreadManager m_threadManager;
    protected ThreadPool m_threadPool;
    protected String m_serverSocketType = "plain";
    protected int m_port;
    protected InetAddress m_bindTo;
    protected ServerSocket m_serverSocket;
    protected String m_connectionName;
    static /* synthetic */ Class class$org$apache$avalon$cornerstone$services$connection$ConnectionHandlerFactory;

    protected String getThreadPoolName() {
        return null;
    }

    protected abstract ConnectionHandlerFactory createFactory();

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        ContainerUtil.enableLogging((Object)this.m_factory, (Logger)logger);
    }

    public void contextualize(Context context) throws ContextException {
        ContainerUtil.contextualize((Object)this.m_factory, (Context)context);
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_connectionManager = (ConnectionManager)serviceManager.lookup(ConnectionManager.ROLE);
        this.m_socketManager = (SocketManager)serviceManager.lookup(SocketManager.ROLE);
        if (null != this.getThreadPoolName()) {
            this.m_threadManager = (ThreadManager)serviceManager.lookup(ThreadManager.ROLE);
            this.m_threadPool = this.m_threadManager.getThreadPool(this.getThreadPoolName());
        }
        ContainerUtil.service((Object)this.m_factory, (ServiceManager)serviceManager);
        try {
            ContainerUtil.compose((Object)this.m_factory, (ComponentManager)new WrapperComponentManager(serviceManager));
        }
        catch (ComponentException ce) {
            throw new ServiceException((class$org$apache$avalon$cornerstone$services$connection$ConnectionHandlerFactory == null ? (class$org$apache$avalon$cornerstone$services$connection$ConnectionHandlerFactory = AbstractService.class$("org.apache.avalon.cornerstone.services.connection.ConnectionHandlerFactory")) : class$org$apache$avalon$cornerstone$services$connection$ConnectionHandlerFactory).getName(), ce.getMessage(), (Throwable)ce);
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        ContainerUtil.configure((Object)this.m_factory, (Configuration)configuration);
    }

    public void initialize() throws Exception {
        ContainerUtil.initialize((Object)this.m_factory);
        if (null == this.m_connectionName) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.m_serverSocketType);
            sb.append(':');
            sb.append(this.m_port);
            if (null != this.m_bindTo) {
                sb.append('/');
                sb.append(this.m_bindTo);
            }
            this.m_connectionName = sb.toString();
        }
        ServerSocketFactory factory = this.m_socketManager.getServerSocketFactory(this.m_serverSocketType);
        this.m_serverSocket = null == this.m_bindTo ? factory.createServerSocket(this.m_port) : factory.createServerSocket(this.m_port, 5, this.m_bindTo);
        if (null == this.m_threadPool) {
            this.m_connectionManager.connect(this.m_connectionName, this.m_serverSocket, this.m_factory);
        } else {
            this.m_connectionManager.connect(this.m_connectionName, this.m_serverSocket, this.m_factory, this.m_threadPool);
        }
    }

    public void dispose() {
        String message;
        try {
            this.m_connectionManager.disconnect(this.m_connectionName);
        }
        catch (Exception e) {
            message = "Error disconnecting";
            this.getLogger().warn("Error disconnecting", (Throwable)e);
        }
        try {
            this.m_serverSocket.close();
        }
        catch (IOException ioe) {
            message = "Error closing server socket";
            this.getLogger().warn("Error closing server socket", (Throwable)ioe);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

