/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.Vector;
import org.apache.avalon.cornerstone.blocks.connection.ConnectionMonitor;
import org.apache.avalon.cornerstone.blocks.connection.ConnectionRunner;
import org.apache.avalon.cornerstone.services.connection.ConnectionHandlerFactory;
import org.apache.excalibur.thread.ThreadPool;

class Connection
implements Runnable {
    private final ServerSocket m_serverSocket;
    private final ConnectionHandlerFactory m_handlerFactory;
    private final ThreadPool m_threadPool;
    private final Vector m_runners = new Vector();
    private Thread m_thread;
    protected ConnectionMonitor monitor;

    public Connection(ServerSocket serverSocket, ConnectionHandlerFactory handlerFactory, ThreadPool threadPool, ConnectionMonitor monitor) {
        this.m_serverSocket = serverSocket;
        this.m_handlerFactory = handlerFactory;
        this.m_threadPool = threadPool;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws Exception {
        Connection connection = this;
        synchronized (connection) {
            if (null != this.m_thread) {
                Thread thread = this.m_thread;
                this.m_thread = null;
                thread.interrupt();
                this.wait();
            }
        }
        Iterator runners = this.m_runners.iterator();
        while (runners.hasNext()) {
            ConnectionRunner runner = (ConnectionRunner)runners.next();
            runner.dispose();
        }
        this.m_runners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.m_thread = Thread.currentThread();
        while (null != this.m_thread && !Thread.interrupted()) {
            String message;
            try {
                Socket socket = this.m_serverSocket.accept();
                ConnectionRunner runner = new ConnectionRunner(socket, this.m_runners, this.m_handlerFactory, this.monitor);
                this.m_threadPool.execute((Runnable)runner);
            }
            catch (InterruptedIOException iioe) {
            }
            catch (IOException ioe) {
                message = "Exception accepting connection";
                this.monitor.acceptingConnectionException(this.getClass(), "Exception accepting connection", ioe);
            }
            catch (Exception e) {
                message = "Exception executing runner";
                this.monitor.unexpectedException(this.getClass(), "Exception executing runner", e);
            }
        }
        Connection connection = this;
        synchronized (connection) {
            this.notifyAll();
            this.m_thread = null;
        }
    }
}

