/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import xdoclet.util.Translator;

public final class FileManager {
    private static final Map urlCache = new HashMap();
    private static /* synthetic */ Class class$Lxdoclet$XDocletMessages;

    public static final synchronized String getURLContent(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url shouldn't be null!");
        }
        String content = (String)urlCache.get(url);
        if (content != null) {
            return content;
        }
        try {
            InputStream is = null;
            is = "file".equals(url.getProtocol()) ? new FileInputStream(url.getFile()) : url.openStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(is.available());
            FileManager.pump(is, baos);
            content = new String(baos.toByteArray());
            urlCache.put(url, content);
            return content;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(Translator.getString(class$Lxdoclet$XDocletMessages != null ? class$Lxdoclet$XDocletMessages : (class$Lxdoclet$XDocletMessages = FileManager.class$("xdoclet.XDocletMessages")), "EXCEPTION_READING_MERGE_FILE", new String[]{e.toString()}));
            return null;
        }
    }

    public static final synchronized void writeURLContent(URL url, File destination) throws IOException {
        FileOutputStream fos = new FileOutputStream(destination);
        FileManager.pump(url.openStream(), fos);
        fos.flush();
        fos.close();
    }

    /*
     * WARNING - void declaration
     */
    private static final void pump(InputStream is, OutputStream os) throws IOException {
        int len;
        byte[] b = new byte[is.available()];
        while (is.available() > 0 && (len = is.read(b)) != -1) {
            void var3_3;
            os.write(b, 0, (int)var3_3);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

